/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Transform;
import swingwt.awt.BasicStroke;
import swingwt.awt.Color;
import swingwt.awt.Composite;
import swingwt.awt.Font;
import swingwt.awt.FontMetrics;
import swingwt.awt.Graphics;
import swingwt.awt.Graphics2D;
import swingwt.awt.GraphicsConfiguration;
import swingwt.awt.Image;
import swingwt.awt.Paint;
import swingwt.awt.Rectangle;
import swingwt.awt.RenderingHints;
import swingwt.awt.Shape;
import swingwt.awt.Stroke;
import swingwt.awt.font.FontRenderContext;
import swingwt.awt.font.GlyphVector;
import swingwt.awt.geom.AffineTransform;
import swingwt.awt.geom.PathIterator;
import swingwt.awt.geom.SWTPathIterator;
import swingwt.awt.image.ImageObserver;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class SWTGraphics2DRenderer
extends Graphics2D {
    protected GC gc = null;
    protected Font f = null;
    protected Color c = null;
    protected Stroke stroke = null;
    protected boolean shouldDestroy = false;

    public SWTGraphics2DRenderer(final GC gcon) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc = gcon;
                SWTGraphics2DRenderer.this.f = new Font(SWTGraphics2DRenderer.this.gc.getFont());
                SWTGraphics2DRenderer.this.c = new Color(SWTGraphics2DRenderer.this.gc.getForeground());
            }
        });
    }

    public SWTGraphics2DRenderer(GC gc, boolean needToCleanUp) {
        this(gc);
        this.shouldDestroy = needToCleanUp;
    }

    public Graphics create() {
        return this;
    }

    public void dispose() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.dispose();
            }
        });
    }

    public GC getSWTGC() {
        return this.gc;
    }

    public void clearRect(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.fillRectangle(x, y, width, height);
            }
        });
    }

    public void clipRect(int x, int y, int width, int height) {
    }

    public void copyArea(final int x, final int y, final int width, final int height, final int dx, final int dy) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.copyArea(x, y, width, height, dx, dy);
            }
        });
    }

    public void redrawUnder(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)SwingWTUtils.getDisplay(), width, height);
                SWTGraphics2DRenderer.this.gc.copyArea(image, x, y);
                SWTGraphics2DRenderer.this.gc.drawImage(image, x, y);
            }
        });
    }

    public void drawArc(final int x, final int y, final int width, final int height, final int startAngle, final int arcAngle) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
            }
        });
    }

    public void drawBytes(final byte[] data, int offset, int length, final int x, final int y) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(new String(data), x, y, true);
            }
        });
    }

    public void drawChars(final char[] data, int offset, int length, final int x, final int y) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(new String(data), x, y, true);
            }
        });
    }

    public boolean drawImage(final Image img, final int x, final int y, Color bgcolor, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int x, final int y, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int x, final int y, int width, int height, Color bgcolor, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int x, final int y, final int width, final int height, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, 0, 0, img.getWidth(null), img.getHeight(null), x, y, width, height);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int dx1, final int dy1, final int dx2, final int dy2, final int sx1, final int sy1, final int sx2, final int sy2, Color bgcolor, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, sx1, sy1, sx2 - sx1, sy2 - sy1, dx1, dy1, dx2 - dx1, dy2 - dy1);
            }
        });
        return true;
    }

    public boolean drawImage(final Image img, final int dx1, final int dy1, final int dx2, final int dy2, final int sx1, final int sy1, final int sx2, final int sy2, ImageObserver observer) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawImage(img.image, sx1, sy1, sx2 - sx1, sy2 - sy1, dx1, dy1, dx2 - dx1, dy2 - dy1);
            }
        });
        return true;
    }

    public void drawLine(final int x1, final int y1, final int x2, final int y2) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawLine(x1, y1, x2, y2);
            }
        });
    }

    public void drawOval(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawOval(x, y, width, height);
            }
        });
    }

    public void drawPolygon(final int[] xPoints, final int[] yPoints, final int nPoints) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawPolygon(SWTGraphics2DRenderer.this.mergeArrays(xPoints, yPoints, nPoints));
            }
        });
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.gc.drawPolyline(this.mergeArrays(xPoints, yPoints, nPoints));
    }

    public void drawString(String s, float x, float y) {
        this.drawString(s, (int)x, (int)y);
    }

    public void drawString(final String str, final int x, final int y) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(str, x, y, false);
            }
        });
    }

    public void drawString(final String str, final int x, final int y, final boolean transparent) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.drawString(str, x, y, transparent);
            }
        });
    }

    public void fillArc(final int x, final int y, final int width, final int height, final int startAngle, final int arcAngle) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillArc(x, y, width, height, startAngle, arcAngle);
            }
        });
    }

    public void fillOval(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillOval(x, y, width, height);
            }
        });
    }

    public void fillPolygon(final int[] xPoints, final int[] yPoints, final int nPoints) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                org.eclipse.swt.graphics.Color old = SWTGraphics2DRenderer.this.gc.getBackground();
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillPolygon(SWTGraphics2DRenderer.this.mergeArrays(xPoints, yPoints, nPoints));
                SWTGraphics2DRenderer.this.gc.setBackground(old);
            }
        });
    }

    public void fillRect(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(SWTGraphics2DRenderer.this.c.getSWTColor());
                SWTGraphics2DRenderer.this.gc.fillRectangle(x, y, width, height);
            }
        });
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRect(x, y, width, height);
    }

    public Font getFont() {
        return this.f;
    }

    public Color getColor() {
        return this.c;
    }

    public void setFont(Font f) {
        if (f != this.f) {
            this.f = f;
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    SWTGraphics2DRenderer.this.gc.setFont(SWTGraphics2DRenderer.this.f.getSWTFont());
                }
            });
        }
    }

    public void setColor(Color color) {
        this.c = color;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setForeground(SWTGraphics2DRenderer.this.c.getSWTColor());
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.shouldDestroy) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    SWTGraphics2DRenderer.this.gc.dispose();
                }
            });
        }
    }

    public void addRenderingHints(Map hints) {
    }

    public void clip(Shape s) {
    }

    protected Path getSWTPath(Shape s) {
        PathIterator path = s.getPathIterator(null);
        Path swtPath = null;
        if (path instanceof SWTPathIterator) {
            swtPath = ((SWTPathIterator)path).getSWTPath();
        }
        return swtPath;
    }

    public void draw(Shape s) {
        Path swtPath = this.getSWTPath(s);
        this.gc.drawPath(swtPath);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public void fill(Shape s) {
        Path swtPath = this.getSWTPath(s);
        this.gc.fillPath(swtPath);
    }

    public Color getBackground() {
        return new Color(this.gc.getBackground());
    }

    public Composite getComposite() {
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public Paint getPaint() {
        return null;
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        Transform gTrans = new Transform((Device)SwingWTUtils.getDisplay());
        this.gc.getTransform(gTrans);
        return new AffineTransform(gTrans);
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public void rotate(double theta) {
    }

    public void rotate(double theta, double x, double y) {
    }

    public void scale(double sx, double sy) {
    }

    public void setBackground(final Color color) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setBackground(color.getSWTColor());
            }
        });
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public void setRenderingHints(Map hints) {
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
        if (!(s instanceof BasicStroke)) {
            return;
        }
        BasicStroke bs = (BasicStroke)s;
        this.gc.setLineWidth((int)bs.width);
        int gcCap = 3;
        switch (bs.cap) {
            case 0: {
                gcCap = 1;
                break;
            }
            case 1: {
                gcCap = 2;
                break;
            }
            case 2: {
                gcCap = 3;
            }
        }
        this.gc.setLineCap(gcCap);
        int gcJoin = 1;
        switch (bs.join) {
            case 2: {
                gcJoin = 3;
                break;
            }
            case 0: {
                gcJoin = 1;
                break;
            }
            case 1: {
                gcJoin = 2;
            }
        }
        this.gc.setLineJoin(gcJoin);
    }

    public void setTransform(AffineTransform Tx) {
        Transform trans = Tx.getSWTTransform();
        this.gc.setTransform(trans);
    }

    public void shear(double shx, double shy) {
    }

    public void transform(AffineTransform Tx) {
        Transform trans = Tx.getSWTTransform();
        Transform gTrans = new Transform((Device)SwingWTUtils.getDisplay());
        gTrans.multiply(trans);
        this.gc.setTransform(gTrans);
    }

    public void translate(double tx, double ty) {
        Transform trans = new Transform((Device)SwingWTUtils.getDisplay());
        this.gc.getTransform(trans);
        trans.translate((float)tx, (float)ty);
        this.gc.setTransform(trans);
    }

    public void translate(int x, int y) {
        Transform trans = new Transform((Device)SwingWTUtils.getDisplay());
        this.gc.getTransform(trans);
        trans.translate((float)x, (float)y);
        this.gc.setTransform(trans);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        final Rectangle r = new Rectangle();
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                org.eclipse.swt.graphics.Rectangle rc = SWTGraphics2DRenderer.this.gc.getClipping();
                r.height = rc.height;
                r.width = rc.width;
                r.x = rc.x;
                r.y = rc.y;
            }
        });
        return r;
    }

    public FontMetrics getFontMetrics(Font f) {
        return new FontMetrics(f);
    }

    public void setClip(Shape clip) {
    }

    public void setClip(final int x, final int y, final int width, final int height) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                SWTGraphics2DRenderer.this.gc.setClipping(x, y, width, height);
            }
        });
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    private int[] mergeArrays(int[] a1, int[] a2, int n) {
        int len = n * 2;
        int[] result = new int[len];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            result[j] = a1[i];
            result[j + 1] = a2[i];
            j += 2;
        }
        return result;
    }
}

