/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import swingwt.awt.Dimension;
import swingwt.awt.Point;
import swingwt.awt.Shape;
import swingwt.awt.geom.Point2D;
import swingwt.awt.geom.Rectangle2D;

public class Rectangle
extends Rectangle2D
implements Shape {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle(Point p, Dimension d) {
        this(p.x, p.y, d.width, d.height);
    }

    public Rectangle(Point p) {
        this(p.x, p.y, 0, 0);
    }

    public Rectangle(Dimension d) {
        this(0, 0, d.width, d.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public void setRect(double x, double y, double width, double height) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int x1 = (int)Math.ceil(x + width);
        int y1 = (int)Math.ceil(y + height);
        this.setBounds(x0, y0, x1 - x0, y1 - y0);
    }

    public void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.move(x, y);
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.inside(x, y);
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public boolean contains(int X, int Y, int W, int H) {
        return super.contains(X, Y, W, H);
    }

    public boolean inside(int X, int Y) {
        return this.width > 0 && this.height > 0 && X >= this.x && X < this.x + this.width && Y >= this.y && Y < this.y + this.height;
    }

    public boolean intersects(Rectangle r) {
        return super.intersects(r.x, r.y, r.width, r.height);
    }

    public Rectangle intersection(Rectangle r) {
        Rectangle retval = new Rectangle();
        Rectangle.intersect(this, r, retval);
        return retval;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public boolean contains(Rectangle2D r) {
        return this.contains((Rectangle)r);
    }

    public boolean contains(Point2D p) {
        return this.contains((Point)p);
    }

    public boolean contains(double x, double y) {
        return this.contains((int)x, (int)y);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.contains((int)x, (int)y, (int)w, (int)h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects((Rectangle)r);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects((int)x, (int)y, (int)w, (int)h);
    }

    public void grow(int h, int v) {
        this.x -= h;
        this.y -= v;
        this.width += 2 * h;
        this.height += 2 * v;
    }

    public Rectangle2D createIntersection(Rectangle2D r) {
        Rectangle2D retval = (Rectangle2D)this.clone();
        Rectangle.intersect(this, r, retval);
        return retval;
    }

    public Rectangle union(Rectangle r) {
        Rectangle retval = (Rectangle)this.clone();
        Rectangle.union(this, r, retval);
        return retval;
    }

    public Rectangle2D createUnion(Rectangle2D r) {
        Rectangle2D retval = (Rectangle2D)this.clone();
        Rectangle.union(this, r, retval);
        return retval;
    }

    public int outcode(double x, double y) {
        return 0;
    }
}

