/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.graphics.FontData;
import swingwt.awt.Font;
import swingwt.awt.Graphics2D;
import swingwt.awt.GraphicsDevice;
import swingwt.awt.HeadlessException;
import swingwt.awt.Point;
import swingwt.awt.Rectangle;
import swingwt.awt.Toolkit;
import swingwt.awt.image.BufferedImage;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class GraphicsEnvironment {
    private static GraphicsEnvironment instance = new GraphicsEnvironment();
    private Object retval = null;

    protected GraphicsEnvironment() {
    }

    public static GraphicsEnvironment getLocalGraphicsEnvironment() {
        return instance;
    }

    public static boolean isHeadless() {
        return false;
    }

    public boolean isHeadlessInstance() {
        return false;
    }

    public Graphics2D createGraphics(BufferedImage img) {
        return img.createGraphics();
    }

    public Font[] getAllFonts() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                FontData[] f = SwingWTUtils.getDisplay().getFontList(null, true);
                Font[] fn = new Font[f.length];
                for (int i = 0; i < f.length; ++i) {
                    fn[i] = new Font(f[i]);
                }
                GraphicsEnvironment.this.retval = fn;
            }
        });
        return (Font[])this.retval;
    }

    public String[] getAvailableFontFamilyNames() {
        Font[] fonts = this.getAllFonts();
        Vector<String> s = new Vector<String>();
        String lastfont = "";
        for (int i = 0; i < fonts.length; ++i) {
            if (lastfont.trim().equals(fonts[i].getFontName().trim())) continue;
            s.add(fonts[i].getFontName());
            lastfont = fonts[i].getFontName();
        }
        String[] r = new String[s.size()];
        for (int i = 0; i < s.size(); ++i) {
            r[i] = s.get(i).toString();
        }
        return r;
    }

    public String[] getAvailableFontFamilyNames(Locale l) {
        return this.getAvailableFontFamilyNames();
    }

    public Point getCenterPoint() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return new Point(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return new GraphicsDevice();
    }

    public Rectangle getMaximumWindowBounds() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return new Rectangle(0, 0, Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height);
    }

    public GraphicsDevice[] getScreenDevices() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return new GraphicsDevice[]{this.getDefaultScreenDevice()};
    }
}

