/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHMENUBARINFO;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    public int handle;
    int x;
    int y;
    int hBrush;
    int hwndCB;
    int id0;
    int id1;
    int foreground = -1;
    int background = -1;
    Image backgroundImage;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;
    ImageList imageList;
    static final int ID_PPC = 100;
    static final int ID_SPMM = 102;
    static final int ID_SPBM = 103;
    static final int ID_SPMB = 104;
    static final int ID_SPBB = 105;
    static final int ID_SPSOFTKEY0 = 106;
    static final int ID_SPSOFTKEY1 = 107;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        this(decorations, Menu.checkStyle(n), 0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    Menu(Decorations decorations, int n, int n2) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.handle = n2;
        this.checkOrientation(decorations);
        this.createWidget();
    }

    void _setVisible(boolean bl) {
        if ((this.style & 6) != 0) {
            return;
        }
        int n = this.parent.handle;
        if (bl) {
            int n2;
            int n3 = 0;
            if (OS.GetKeyState(1) >= 0) {
                n3 |= 2;
            }
            if ((this.style & 0x4000000) != 0) {
                n3 |= 8;
            }
            if ((this.parent.style & 0x8000000) != 0) {
                n3 &= 0xFFFFFFF7;
                if ((this.style & 0x2000000) != 0) {
                    n3 |= 8;
                }
            }
            int n4 = this.x;
            int n5 = this.y;
            if (!this.hasLocation) {
                n2 = OS.GetMessagePos();
                n4 = (short)(n2 & 0xFFFF);
                n5 = (short)(n2 >> 16);
            }
            if ((n2 = (int)(OS.TrackPopupMenu(this.handle, n3, n4, n5, 0, n, null) ? 1 : 0)) == 0 && this.GetMenuItemCount(this.handle) == 0) {
                OS.SendMessage(n, 287, -65536, 0);
            }
        } else {
            OS.SendMessage(n, 31, 0, 0);
        }
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        if (this.handle != 0) {
            return;
        }
        if ((this.style & 2) != 0) {
            if (OS.IsPPC) {
                int n = this.parent.handle;
                SHMENUBARINFO sHMENUBARINFO = new SHMENUBARINFO();
                sHMENUBARINFO.cbSize = SHMENUBARINFO.sizeof;
                sHMENUBARINFO.hwndParent = n;
                sHMENUBARINFO.dwFlags = 2;
                sHMENUBARINFO.nToolBarId = 100;
                sHMENUBARINFO.hInstRes = OS.GetLibraryHandle();
                boolean bl = OS.SHCreateMenuBar(sHMENUBARINFO);
                this.hwndCB = sHMENUBARINFO.hwndMB;
                if (!bl) {
                    this.error(2);
                }
                OS.SendMessage(this.hwndCB, 1046, 0, 0);
                return;
            }
            if (OS.IsSP) {
                MenuItem menuItem;
                Menu menu;
                int n;
                int n2 = (this.style & 0x80000) != 0 ? ((this.style & 0x100000) != 0 ? 105 : 103) : ((this.style & 0x100000) != 0 ? 104 : 102);
                SHMENUBARINFO sHMENUBARINFO = new SHMENUBARINFO();
                sHMENUBARINFO.cbSize = SHMENUBARINFO.sizeof;
                sHMENUBARINFO.hwndParent = this.parent.handle;
                sHMENUBARINFO.dwFlags = 2;
                sHMENUBARINFO.nToolBarId = n2;
                sHMENUBARINFO.hInstRes = OS.GetLibraryHandle();
                if (!OS.SHCreateMenuBar(sHMENUBARINFO)) {
                    this.error(2);
                }
                this.hwndCB = sHMENUBARINFO.hwndMB;
                OS.ShowWindow(this.hwndCB, 0);
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                tBBUTTONINFO.dwMask = 32;
                if (n2 == 102 || n2 == 104) {
                    n = OS.SendMessage(this.hwndCB, 1425, 0, 106);
                    OS.RemoveMenu(n, 0, 1024);
                    menu = new Menu(this.parent, 4, n);
                    menuItem = new MenuItem(this, menu, 64, 0);
                } else {
                    menuItem = new MenuItem(this, null, 8, 0);
                }
                tBBUTTONINFO.idCommand = this.id0 = menuItem.id;
                OS.SendMessage(this.hwndCB, OS.TB_SETBUTTONINFO, 106, tBBUTTONINFO);
                if (n2 == 102 || n2 == 103) {
                    n = OS.SendMessage(this.hwndCB, 1425, 0, 107);
                    OS.RemoveMenu(n, 0, 1024);
                    menu = new Menu(this.parent, 4, n);
                    menuItem = new MenuItem(this, menu, 64, 1);
                } else {
                    menuItem = new MenuItem(this, null, 8, 1);
                }
                tBBUTTONINFO.idCommand = this.id1 = menuItem.id;
                OS.SendMessage(this.hwndCB, OS.TB_SETBUTTONINFO, 107, tBBUTTONINFO);
                n = 3;
                int n3 = n << 16 | n;
                OS.SendMessage(this.hwndCB, 1427, 27, n3);
                return;
            }
            this.handle = OS.CreateMenu();
            if (this.handle == 0) {
                this.error(2);
            }
            if (OS.IsHPC) {
                int n = this.parent.handle;
                this.hwndCB = OS.CommandBar_Create(OS.GetModuleHandle(null), n, 1);
                if (this.hwndCB == 0) {
                    this.error(2);
                }
                OS.CommandBar_Show(this.hwndCB, false);
                OS.CommandBar_InsertMenubarEx(this.hwndCB, 0, this.handle, 0);
                if ((this.parent.style & 0x40) != 0 && (this.parent.style & 0x20) == 0) {
                    OS.CommandBar_AddAdornments(this.hwndCB, 0, 0);
                }
            }
        } else {
            this.handle = OS.CreatePopupMenu();
            if (this.handle == 0) {
                this.error(2);
            }
        }
    }

    void createItem(MenuItem menuItem, int n) {
        int n2 = this.GetMenuItemCount(this.handle);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        this.display.addMenuItem(menuItem);
        boolean bl = false;
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsSP) {
                return;
            }
            TBBUTTON tBBUTTON = new TBBUTTON();
            tBBUTTON.idCommand = menuItem.id;
            tBBUTTON.fsStyle = (byte)16;
            if ((menuItem.style & 0x40) != 0) {
                tBBUTTON.fsStyle = (byte)(tBBUTTON.fsStyle | 0x88);
            }
            if ((menuItem.style & 2) != 0) {
                tBBUTTON.fsStyle = 1;
            }
            tBBUTTON.fsState = (byte)4;
            tBBUTTON.iBitmap = -2;
            bl = OS.SendMessage(this.hwndCB, OS.TB_INSERTBUTTON, n, tBBUTTON) != 0;
        } else if (OS.IsWinCE) {
            int n3 = 1024;
            TCHAR tCHAR = null;
            if ((menuItem.style & 2) != 0) {
                n3 |= 0x800;
            } else {
                tCHAR = new TCHAR(0, " ", true);
            }
            bl = OS.InsertMenu(this.handle, n, n3, menuItem.id, tCHAR);
            if (bl) {
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 32;
                mENUITEMINFO.dwItemData = menuItem.id;
                bl = OS.SetMenuItemInfo(this.handle, n, true, mENUITEMINFO);
            }
        } else {
            int n4 = OS.GetProcessHeap();
            TCHAR tCHAR = new TCHAR(0, " ", true);
            int n5 = tCHAR.length() * TCHAR.sizeof;
            int n6 = OS.HeapAlloc(n4, 8, n5);
            OS.MoveMemory(n6, tCHAR, n5);
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 50;
            mENUITEMINFO.wID = mENUITEMINFO.dwItemData = menuItem.id;
            mENUITEMINFO.fType = menuItem.widgetStyle();
            mENUITEMINFO.dwTypeData = n6;
            bl = OS.InsertMenuItem(this.handle, n, true, mENUITEMINFO);
            if (n6 != 0) {
                OS.HeapFree(n4, 0, n6);
            }
        }
        if (!bl) {
            this.display.removeMenuItem(menuItem);
            this.error(14);
        }
        this.redraw();
    }

    void createWidget() {
        this.createHandle();
        this.parent.addMenu(this);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_MENU);
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_MENUTEXT);
    }

    void destroyAccelerators() {
        this.parent.destroyAccelerators();
    }

    void destroyItem(MenuItem menuItem) {
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
                int n;
                if (OS.IsSP) {
                    this.redraw();
                    return;
                }
                int n2 = OS.SendMessage(this.hwndCB, 1049, menuItem.id, 0);
                if (OS.SendMessage(this.hwndCB, 1046, n2, 0) == 0) {
                    this.error(15);
                }
                if ((n = OS.SendMessage(this.hwndCB, 1048, 0, 0)) == 0 && this.imageList != null) {
                    OS.SendMessage(this.handle, 1072, 0, 0);
                    this.display.releaseImageList(this.imageList);
                    this.imageList = null;
                }
            } else {
                int n = 0;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 32;
                while (OS.GetMenuItemInfo(this.handle, n, true, mENUITEMINFO)) {
                    if (mENUITEMINFO.dwItemData == menuItem.id) break;
                    ++n;
                }
                if (mENUITEMINFO.dwItemData != menuItem.id) {
                    this.error(15);
                }
                if (!OS.DeleteMenu(this.handle, n, 1024)) {
                    this.error(15);
                }
            }
        } else if (!OS.DeleteMenu(this.handle, menuItem.id, 0)) {
            this.error(15);
        }
        this.redraw();
    }

    void destroyWidget() {
        int n = this.handle;
        int n2 = this.hwndCB;
        this.releaseHandle();
        if (OS.IsWinCE && n2 != 0) {
            OS.CommandBar_Destroy(n2);
        } else if (n != 0) {
            OS.DestroyMenu(n);
        }
    }

    void fixMenus(Decorations decorations) {
        MenuItem[] menuItemArray = this.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            menuItemArray[n].fixMenus(decorations);
            ++n;
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    Color getBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.background != -1 ? this.background : this.defaultBackground());
    }

    Image getBackgroundImage() {
        this.checkWidget();
        return this.backgroundImage;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.style & 2) != 0) {
            if (this.parent.menuBar != this) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n = this.parent.handle;
            MENUBARINFO mENUBARINFO = new MENUBARINFO();
            mENUBARINFO.cbSize = MENUBARINFO.sizeof;
            if (OS.GetMenuBarInfo(n, -3, 0, mENUBARINFO)) {
                int n2 = mENUBARINFO.right - mENUBARINFO.left;
                int n3 = mENUBARINFO.bottom - mENUBARINFO.top;
                return new Rectangle(mENUBARINFO.left, mENUBARINFO.top, n2, n3);
            }
        } else {
            RECT rECT;
            RECT rECT2;
            int n = this.GetMenuItemCount(this.handle);
            if (n != 0 && OS.GetMenuItemRect(0, this.handle, 0, rECT2 = new RECT()) && OS.GetMenuItemRect(0, this.handle, n - 1, rECT = new RECT())) {
                int n4 = rECT2.left - 2;
                int n5 = rECT2.top - 2;
                int n6 = rECT.right - rECT.left + 4;
                int n7 = rECT.bottom - rECT2.top + 4;
                return new Rectangle(n4, n5, n6, n7);
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return null;
        }
        int n = OS.GetMenuDefaultItem(this.handle, 0, 1);
        if (n == -1) {
            return null;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 2;
        if (OS.GetMenuItemInfo(this.handle, n, false, mENUITEMINFO)) {
            return this.display.getMenuItem(mENUITEMINFO.wID);
        }
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.foreground != -1 ? this.foreground : this.defaultForeground());
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        int n2 = 0;
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsPPC) {
                TBBUTTON tBBUTTON = new TBBUTTON();
                int n3 = OS.SendMessage(this.hwndCB, 1047, n, tBBUTTON);
                if (n3 == 0) {
                    this.error(8);
                }
                n2 = tBBUTTON.idCommand;
            }
            if (OS.IsSP) {
                if (n < 0 || n > 1) {
                    this.error(8);
                }
                n2 = n == 0 ? this.id0 : this.id1;
            }
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            if (!OS.GetMenuItemInfo(this.handle, n, true, mENUITEMINFO)) {
                this.error(6);
            }
            n2 = mENUITEMINFO.dwItemData;
        }
        return this.display.getMenuItem(n2);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.GetMenuItemCount(this.handle);
    }

    public MenuItem[] getItems() {
        MenuItem[] menuItemArray;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsSP) {
                MenuItem[] menuItemArray2 = new MenuItem[]{this.display.getMenuItem(this.id0), this.display.getMenuItem(this.id1)};
                return menuItemArray2;
            }
            int n = OS.SendMessage(this.hwndCB, 1048, 0, 0);
            TBBUTTON tBBUTTON = new TBBUTTON();
            MenuItem[] menuItemArray3 = new MenuItem[n];
            int n2 = 0;
            while (n2 < n) {
                OS.SendMessage(this.hwndCB, 1047, n2, tBBUTTON);
                menuItemArray3[n2] = this.display.getMenuItem(tBBUTTON.idCommand);
                ++n2;
            }
            return menuItemArray3;
        }
        int n = 0;
        int n3 = 0;
        int n4 = OS.IsWinCE ? 4 : OS.GetMenuItemCount(this.handle);
        MenuItem[] menuItemArray4 = new MenuItem[n4];
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, n, true, mENUITEMINFO)) {
            if (n3 == menuItemArray4.length) {
                menuItemArray = new MenuItem[n3 + 4];
                System.arraycopy(menuItemArray4, 0, menuItemArray, 0, n3);
                menuItemArray4 = menuItemArray;
            }
            if ((menuItemArray = this.display.getMenuItem(mENUITEMINFO.dwItemData)) != null) {
                menuItemArray4[n3++] = menuItemArray;
            }
            ++n;
        }
        if (n3 == menuItemArray4.length) {
            return menuItemArray4;
        }
        menuItemArray = new MenuItem[n3];
        System.arraycopy(menuItemArray4, 0, menuItemArray, 0, n3);
        return menuItemArray;
    }

    int GetMenuItemCount(int n) {
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
                return OS.IsSP ? 2 : OS.SendMessage(this.hwndCB, 1048, 0, 0);
            }
            int n2 = 0;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            while (OS.GetMenuItemInfo(n, n2, true, mENUITEMINFO)) {
                ++n2;
            }
            return n2;
        }
        return OS.GetMenuItemCount(n);
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                string = String.valueOf(string) + menuItemArray[n2].getNameText() + ", ";
                ++n2;
            }
            string = String.valueOf(string) + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            menuArray = this.display.popups;
            if (menuArray == null) {
                return false;
            }
            int n = 0;
            while (n < menuArray.length) {
                if (menuArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        menuArray = this.getShell();
        Menu menu = menuArray.activeMenu;
        while (menu != null && menu != this) {
            menu = menu.getParentMenu();
        }
        return this == menu;
    }

    int imageIndex(Image image) {
        if (this.hwndCB == 0 || image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n = this.imageList.add(image);
            int n2 = this.imageList.getHandle();
            OS.SendMessage(this.hwndCB, 1072, 0, n2);
            return n;
        }
        int n = this.imageList.indexOf(image);
        if (n == -1) {
            n = this.imageList.add(image);
        } else {
            this.imageList.put(n, image);
        }
        return n;
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        if (menuItem.isDisposed()) {
            this.error(5);
        }
        if (menuItem.parent != this) {
            return -1;
        }
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsPPC) {
                return OS.SendMessage(this.hwndCB, 1049, menuItem.id, 0);
            }
            if (OS.IsSP) {
                if (menuItem.id == this.id0) {
                    return 0;
                }
                if (menuItem.id == this.id1) {
                    return 1;
                }
                return -1;
            }
        }
        int n = 0;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, n, true, mENUITEMINFO)) {
            if (mENUITEMINFO.dwItemData == menuItem.id) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void redraw() {
        if (!this.isVisible()) {
            return;
        }
        if ((this.style & 2) != 0) {
            this.display.addBar(this);
        } else {
            this.update();
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndCB = 0;
        this.handle = 0;
    }

    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            if (menuItem != null && !menuItem.isDisposed()) {
                if (OS.IsPPC && this.hwndCB != 0) {
                    menuItem.dispose();
                } else {
                    menuItem.release(false);
                }
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.releaseMenu();
        }
        if ((this.style & 2) != 0) {
            this.display.removeBar(this);
            if (this == this.parent.menuBar) {
                this.parent.setMenuBar(null);
            }
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.backgroundImage = null;
        if (this.hBrush == 0) {
            OS.DeleteObject(this.hBrush);
        }
        this.hBrush = 0;
        if (OS.IsPPC && this.hwndCB != 0 && this.imageList != null) {
            OS.SendMessage(this.hwndCB, 1072, 0, 0);
            this.display.releaseToolImageList(this.imageList);
            this.imageList = null;
        }
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void setBackground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            n = color.handle;
        }
        if (n == this.background) {
            return;
        }
        this.background = n;
        this.updateBackground();
    }

    void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackground();
    }

    void setForeground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            n = color.handle;
        }
        if (n == this.foreground) {
            return;
        }
        this.foreground = n;
        this.updateForeground();
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        int n = -1;
        if (menuItem != null) {
            if (menuItem.isDisposed()) {
                this.error(5);
            }
            if (menuItem.parent != this) {
                return;
            }
            n = menuItem.id;
        }
        if (OS.IsWinCE) {
            return;
        }
        int n2 = OS.GetMenuDefaultItem(this.handle, 0, 1);
        if (n == n2) {
            return;
        }
        OS.SetMenuDefaultItem(this.handle, n, 0);
        this.redraw();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.state &= 0xFFFFFFF7;
        if (!bl) {
            this.state |= 8;
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    void update() {
        if (OS.IsPPC || OS.IsSP) {
            return;
        }
        if (OS.IsHPC) {
            Menu menu = this.parent.menuBar;
            if (menu != null) {
                Menu menu2 = this;
                while (menu2 != null && menu2 != menu) {
                    menu2 = menu2.getParentMenu();
                }
                if (menu2 == menu) {
                    OS.CommandBar_DrawMenuBar(menu.hwndCB, 0);
                    OS.CommandBar_Show(menu.hwndCB, true);
                }
            }
            return;
        }
        if (OS.IsWinCE) {
            return;
        }
        if ((this.style & 2) != 0) {
            if (this == this.parent.menuBar) {
                OS.DrawMenuBar(this.parent.handle);
            }
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        MenuItem[] menuItemArray = this.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            if (menuItem.image != null) {
                bl2 = true;
                if (true && bl) break;
            }
            if ((menuItem.style & 0x30) != 0) {
                bl = true;
                if (true && bl2) break;
            }
            ++n;
        }
        if (!OS.IsWin95 && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 128;
            int n2 = 0;
            while (n2 < menuItemArray.length) {
                MenuItem menuItem = menuItemArray[n2];
                if ((this.style & 2) == 0 && (menuItem.image == null || this.foreground != -1)) {
                    mENUITEMINFO.hbmpItem = bl2 || this.foreground != -1 ? -1 : 0;
                    OS.SetMenuItemInfo(this.handle, menuItem.id, false, mENUITEMINFO);
                }
                ++n2;
            }
        }
        MENUINFO mENUINFO = new MENUINFO();
        mENUINFO.cbSize = MENUINFO.sizeof;
        mENUINFO.fMask = 16;
        OS.GetMenuInfo(this.handle, mENUINFO);
        mENUINFO.dwStyle = bl2 && !bl ? (mENUINFO.dwStyle |= 0x4000000) : (mENUINFO.dwStyle &= 0xFBFFFFFF);
        OS.SetMenuInfo(this.handle, mENUINFO);
    }

    void updateBackground() {
        if (this.hBrush == 0) {
            OS.DeleteObject(this.hBrush);
        }
        this.hBrush = 0;
        if (this.backgroundImage != null) {
            this.hBrush = OS.CreatePatternBrush(this.backgroundImage.handle);
        } else if (this.background != -1) {
            this.hBrush = OS.CreateSolidBrush(this.background);
        }
        MENUINFO mENUINFO = new MENUINFO();
        mENUINFO.cbSize = MENUINFO.sizeof;
        mENUINFO.fMask = 2;
        mENUINFO.hbrBack = this.hBrush;
        OS.SetMenuInfo(this.handle, mENUINFO);
    }

    void updateForeground() {
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        int n = 0;
        while (OS.GetMenuItemInfo(this.handle, n, true, mENUITEMINFO)) {
            mENUITEMINFO.fMask = 128;
            mENUITEMINFO.hbmpItem = -1;
            OS.SetMenuItemInfo(this.handle, n, true, mENUITEMINFO);
            ++n;
        }
        this.redraw();
    }
}

