/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 32768);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int n;
        int n2;
        Object object;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n3 = 0;
        if (this.parent != null) {
            n3 = this.parent.handle;
        }
        int n4 = OS.GetProcessHeap();
        CHOOSEFONT cHOOSEFONT = new CHOOSEFONT();
        cHOOSEFONT.lStructSize = CHOOSEFONT.sizeof;
        cHOOSEFONT.hwndOwner = n3;
        cHOOSEFONT.Flags = 257;
        int n5 = OS.HeapAlloc(n4, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            object = this.fontData.data;
            n2 = ((LOGFONT)object).lfHeight;
            n = OS.GetDC(0);
            int n6 = -((int)(0.5f + this.fontData.height * (float)OS.GetDeviceCaps(n, 90) / 72.0f));
            OS.ReleaseDC(0, n);
            ((LOGFONT)object).lfHeight = n6;
            cHOOSEFONT.Flags |= 0x40;
            OS.MoveMemory(n5, (LOGFONT)object, LOGFONT.sizeof);
            ((LOGFONT)object).lfHeight = n2;
        }
        cHOOSEFONT.lpLogFont = n5;
        if (this.rgb != null) {
            int n7 = this.rgb.red & 0xFF;
            n2 = this.rgb.green << 8 & 0xFF00;
            n = this.rgb.blue << 16 & 0xFF0000;
            cHOOSEFONT.rgbColors = n7 | n2 | n;
        }
        object = null;
        Display display = null;
        if ((this.style & 0x30000) != 0) {
            display = this.parent.getDisplay();
            object = display.getModalDialogShell();
            display.setModalDialogShell(this.parent);
        }
        n = OS.ChooseFont(cHOOSEFONT) ? 1 : 0;
        if ((this.style & 0x30000) != 0) {
            display.setModalDialogShell((Shell)object);
        }
        if (n != 0) {
            int n8;
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.MoveMemory(lOGFONT, n5, LOGFONT.sizeof);
            int n9 = OS.GetDC(0);
            int n10 = OS.GetDeviceCaps(n9, 90);
            int n11 = 0;
            if (lOGFONT.lfHeight > 0) {
                int n12 = OS.CreateFontIndirect(lOGFONT);
                n8 = OS.SelectObject(n9, n12);
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n9, tEXTMETRIC);
                OS.SelectObject(n9, n8);
                OS.DeleteObject(n12);
                n11 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
            } else {
                n11 = -lOGFONT.lfHeight;
            }
            OS.ReleaseDC(0, n9);
            float f = (float)n11 * 72.0f / (float)n10;
            this.fontData = FontData.win32_new(lOGFONT, f);
            n8 = cHOOSEFONT.rgbColors & 0xFF;
            int n13 = cHOOSEFONT.rgbColors >> 8 & 0xFF;
            int n14 = cHOOSEFONT.rgbColors >> 16 & 0xFF;
            this.rgb = new RGB(n8, n13, n14);
        }
        if (n5 != 0) {
            OS.HeapFree(n4, 0, n5);
        }
        if (n == 0) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

