/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.OS;

public final class Color
extends Resource {
    public int handle;

    Color() {
    }

    public Color(Device device, int n, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n, n2, n3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rGB) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(device, rGB.red, rGB.green, rGB.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        int n;
        int[] nArray;
        if (this.handle == -1) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        int n2 = this.device.hPalette;
        if (n2 != 0 && (nArray = this.device.colorRefCount)[n = OS.GetNearestPaletteIndex(n2, this.handle)] > 0) {
            int n3 = n;
            nArray[n3] = nArray[n3] - 1;
        }
        this.handle = -1;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16);
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int n, int n2, int n3) {
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            SWT.error(5);
        }
        this.device = device;
        this.handle = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
        int n4 = device.hPalette;
        if (n4 == 0) {
            return;
        }
        int[] nArray = device.colorRefCount;
        int n5 = OS.GetNearestPaletteIndex(n4, this.handle);
        byte[] byArray = new byte[4];
        OS.GetPaletteEntries(n4, n5, 1, byArray);
        if (byArray[0] == (byte)n && byArray[1] == (byte)n2 && byArray[2] == (byte)n3) {
            int n6 = n5;
            nArray[n6] = nArray[n6] + 1;
            return;
        }
        int n7 = 0;
        while (n7 < nArray.length) {
            if (nArray[n7] == 0) {
                n5 = n7;
                break;
            }
            ++n7;
        }
        if (n7 == nArray.length) {
            this.handle = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
        } else {
            byte[] byArray2 = new byte[4];
            byArray2[0] = (byte)(n & 0xFF);
            byArray2[1] = (byte)(n2 & 0xFF);
            byArray2[2] = (byte)(n3 & 0xFF);
            byArray = byArray2;
            OS.SetPaletteEntries(n4, n5, 1, byArray);
        }
        int n8 = n5;
        nArray[n8] = nArray[n8] + 1;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color win32_new(Device device, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = n;
        color.device = device;
        return color;
    }
}

