/*
 * Decompiled with CFR 0.152.
 */
package ca.mb.javajeff.pcx;

import ca.mb.javajeff.pcx.PCXImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PCXImageReaderSpi
extends ImageReaderSpi {
    public PCXImageReaderSpi() {
        super("JavaJeff", "1.0", new String[]{"PCX"}, new String[]{"pcx"}, new String[]{"image/x-pcx"}, "ca.mb.javajeff.pcx.PCXImageReader", STANDARD_INPUT_TYPE, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        byte[] byArray = new byte[128];
        try {
            imageInputStream.mark();
            imageInputStream.readFully(byArray);
            imageInputStream.reset();
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray[0] != 10) {
            return false;
        }
        if (byArray[1] != 5) {
            return false;
        }
        if (byArray[2] != 1) {
            return false;
        }
        if (byArray[3] != 1 && byArray[3] != 4 && byArray[3] != 8) {
            return false;
        }
        if (byArray[65] != 1 && byArray[65] != 3) {
            return false;
        }
        if ((byArray[3] == 1 || byArray[3] == 4) && byArray[65] == 3) {
            return false;
        }
        return (byArray[66] & 1) != 1;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new PCXImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "PCX Reader Plug-in by Jeff Friesen";
    }
}

