/*
 * Decompiled with CFR 0.152.
 */
package ca.mb.javajeff.pcx;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PCXImageReader
extends ImageReader {
    private int width;
    private int height;
    private int bitsPerPixel;
    private int nPlanes;
    private int bytesPerLine;
    private int scanlineLength;
    private byte[] scanline;
    private byte[] palette = new byte[768];
    private ImageInputStream stream;
    private boolean gotHeader;

    public PCXImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public int getHeight(int n) throws IIOException {
        this.checkIndex(n);
        this.readHeader();
        return this.height;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) {
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IIOException {
        this.checkIndex(n);
        this.readHeader();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(1));
        return arrayList.iterator();
    }

    @Override
    public int getNumImages(boolean bl) {
        return 1;
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    public int getWidth(int n) throws IIOException {
        this.checkIndex(n);
        this.readHeader();
        return this.width;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        Rectangle rectangle = PCXImageReader.getSourceRegion(imageReadParam, this.width, this.height);
        int n2 = 1;
        int n3 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        Point point = new Point(0, 0);
        if (imageReadParam != null) {
            n2 = imageReadParam.getSourceXSubsampling();
            n3 = imageReadParam.getSourceYSubsampling();
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
            point = imageReadParam.getDestinationOffset();
        }
        BufferedImage bufferedImage = PCXImageReader.getDestination(imageReadParam, this.getImageTypes(0), this.width, this.height);
        PCXImageReader.checkReadParamBandSettings(imageReadParam, 3, bufferedImage.getSampleModel().getNumBands());
        WritableRaster writableRaster = Raster.createBandedRaster(0, this.width, 1, 3, new Point(0, 0));
        byte[][] byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getBankData();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n4 = writableRaster2.getMinX();
        int n5 = n4 + writableRaster2.getWidth() - 1;
        int n6 = writableRaster2.getMinY();
        int n7 = n6 + writableRaster2.getHeight() - 1;
        if (nArray != null) {
            writableRaster = writableRaster.createWritableChild(0, 0, this.width, 1, 0, 0, nArray);
        }
        if (nArray2 != null) {
            writableRaster2 = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), writableRaster2.getHeight(), 0, 0, nArray2);
        }
        int n8 = 0;
        try {
            int[] nArray3 = writableRaster.getPixel(0, 0, (int[])null);
            block2: for (n8 = 0; n8 < this.height; ++n8) {
                int n9;
                this.readScanline();
                this.copyScanlineToBanks(byArray);
                if (n8 < rectangle.y || n8 >= rectangle.y + rectangle.height || (n8 - rectangle.y) % n3 != 0 || (n9 = point.y + (n8 - rectangle.y) / n3) < n6) continue;
                if (n9 <= n7) {
                    for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
                        int n10;
                        if ((i - rectangle.x) % n2 != 0 || (n10 = point.x + (i - rectangle.x) / n2) < n4) continue;
                        if (n10 > n5) continue block2;
                        writableRaster.getPixel(i, 0, nArray3);
                        writableRaster2.setPixel(n10, n9, nArray3);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Error reading line " + n8 + ": " + iOException.getMessage(), iOException);
        }
        return bufferedImage;
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object == null) {
            this.stream = null;
            return;
        }
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("ImageInputStream expected!");
        }
        this.stream = (ImageInputStream)object;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Bad index!");
        }
    }

    private void copyScanlineToBanks(byte[][] byArray) {
        if (this.bitsPerPixel == 1 && this.nPlanes == 1) {
            byte[] byArray2 = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
            for (int i = 0; i < this.width; ++i) {
                byte by = this.scanline[i >> 3];
                boolean bl = (by & byArray2[i & 7]) != 0;
                byArray[0][i] = this.palette[!bl ? 0 : 3];
                byArray[1][i] = this.palette[!bl ? 1 : 4];
                byArray[2][i] = this.palette[!bl ? 2 : 5];
            }
        } else if (this.bitsPerPixel == 4 && this.nPlanes == 1) {
            for (int i = 0; i < this.width; ++i) {
                int n = (i & 1) == 0 ? this.scanline[i >> 1] >> 4 & 0xF : this.scanline[i >> 1] & 0xF;
                n += n + n;
                byArray[0][i] = this.palette[n++];
                byArray[1][i] = this.palette[n++];
                byArray[2][i] = this.palette[n];
            }
        } else if (this.bitsPerPixel == 8 && this.nPlanes == 1) {
            for (int i = 0; i < this.width; ++i) {
                int n = this.scanline[i] & 0xFF;
                n += n + n;
                byArray[0][i] = this.palette[n++];
                byArray[1][i] = this.palette[n++];
                byArray[2][i] = this.palette[n];
            }
        } else {
            System.arraycopy(this.scanline, 0, byArray[0], 0, this.width);
            System.arraycopy(this.scanline, this.bytesPerLine, byArray[1], 0, this.width);
            System.arraycopy(this.scanline, this.bytesPerLine * 2, byArray[2], 0, this.width);
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("No input stream!");
        }
        byte[] byArray = new byte[128];
        try {
            this.stream.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new IIOException("Unable to read header!", iOException);
        }
        if (byArray[0] != 10) {
            throw new IIOException("PCX Manufacturer value incorrect!");
        }
        if (byArray[1] != 5) {
            throw new IIOException("PCX Version value incorrect!");
        }
        if (byArray[2] != 1) {
            throw new IIOException("PCX Encoding value incorrect!");
        }
        if (byArray[3] != 1 && byArray[3] != 4 && byArray[3] != 8) {
            throw new IIOException("PCX BitsPerPixel value incorrect!");
        }
        if (byArray[65] != 1 && byArray[65] != 3) {
            throw new IIOException("PCX NPlanes value incorrect!");
        }
        if ((byArray[3] == 1 || byArray[3] == 4) && byArray[65] == 3) {
            throw new IIOException("PCX BitsPerPixel/NPlanes mismatch!");
        }
        if ((byArray[66] & 1) == 1) {
            throw new IIOException("PCX BytesPerLine value must be even!");
        }
        int n = byArray[5] & 0xFF;
        int n2 = byArray[4] & 0xFF;
        int n3 = n << 8 | n2;
        n = byArray[7] & 0xFF;
        n2 = byArray[6] & 0xFF;
        int n4 = n << 8 | n2;
        n = byArray[9] & 0xFF;
        n2 = byArray[8] & 0xFF;
        int n5 = n << 8 | n2;
        n = byArray[11] & 0xFF;
        n2 = byArray[10] & 0xFF;
        int n6 = n << 8 | n2;
        this.width = n5 - n3 + 1;
        this.height = n6 - n4 + 1;
        this.bitsPerPixel = byArray[3];
        this.nPlanes = byArray[65];
        n = byArray[67] & 0xFF;
        n2 = byArray[66] & 0xFF;
        this.bytesPerLine = n << 8 | n2;
        this.scanlineLength = this.nPlanes * this.bytesPerLine;
        this.scanline = new byte[this.scanlineLength];
        if (this.bitsPerPixel == 8 && this.nPlanes == 1) {
            try {
                this.stream.mark();
                this.stream.seek(this.stream.length());
                this.stream.seek(this.stream.getStreamPosition() - 769L);
                if (this.stream.readUnsignedByte() != 12) {
                    throw new IOException();
                }
                this.stream.read(this.palette);
                this.stream.reset();
            }
            catch (IOException iOException) {
                throw new IIOException("No VGA palette or read error!");
            }
        } else {
            System.arraycopy(byArray, 16, this.palette, 0, 48);
        }
        this.gotHeader = true;
    }

    private void readScanline() throws IOException {
        int n = 0;
        do {
            int n2;
            if (((n2 = this.stream.readUnsignedByte()) & 0xC0) == 192) {
                int n3 = n2 & 0x3F;
                if (n3 == 0) {
                    throw new IOException("Zero run count detected!");
                }
                if (n + n3 - 1 >= this.scanlineLength) {
                    throw new IOException("Scanline overflow!");
                }
                n2 = this.stream.readUnsignedByte();
                for (int i = 1; i <= n3; ++i) {
                    this.scanline[n++] = (byte)n2;
                }
            } else {
                this.scanline[n++] = (byte)n2;
            }
        } while (n < this.scanlineLength);
    }
}

