/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view.charts;

import hu.belicza.andras.bwhfagent.view.ChartsTab;
import swingwtx.swing.JComponent;

public class ChartsParams {
    private static final int AXIS_SPACE_X = 23;
    private static final int AXIS_SPACE_Y = 23;
    public final boolean allPlayersOnOneChart;
    public final int frames;
    public final int playersCount;
    public final int chartsCount;
    public final int chartWidth;
    public final int chartHeight;
    public final int x1;
    public final int maxXInChart;
    public final int maxYInChart;

    public ChartsParams(ChartsTab chartsTab, int frames, int playersCount, JComponent chartsComponent) {
        this.allPlayersOnOneChart = chartsTab.allPlayersOnOneChartCheckBox.isSelected();
        this.frames = frames;
        this.playersCount = playersCount;
        this.chartsCount = this.allPlayersOnOneChart ? 1 : playersCount;
        this.chartWidth = chartsComponent.getWidth() - 23;
        int chartHeight_ = (chartsComponent.getHeight() - 23) / this.chartsCount - 23;
        this.chartHeight = chartHeight_ < 1 ? 1 : chartHeight_;
        this.x1 = 23;
        this.maxXInChart = this.chartWidth - 1;
        this.maxYInChart = this.chartHeight - 1;
    }

    public int getY1ForChart(int chartIndex) {
        return (this.chartHeight + 23) * (this.allPlayersOnOneChart ? 0 : chartIndex) + 23;
    }

    public int getXForIteration(int iteration) {
        return this.x1 + iteration * this.maxXInChart / this.frames;
    }

    public static int getXForTime(int time, int maxTime, JComponent chartsComponent) {
        if (maxTime == 0) {
            maxTime = 1;
        }
        return 23 + time * (chartsComponent.getWidth() - 23 - 1) / maxTime;
    }

    public static int getIterationForX(int x, int maxTime, JComponent chartsComponent) {
        if (x < 23) {
            return -1;
        }
        if (maxTime == 0) {
            maxTime = 1;
        }
        return (x - 23) * maxTime / (chartsComponent.getWidth() - 23 - 1);
    }
}

