/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view.charts;

import hu.belicza.andras.bwhf.control.ReplayScanner;
import hu.belicza.andras.bwhf.model.Action;
import hu.belicza.andras.bwhf.model.HackDescription;
import hu.belicza.andras.bwhf.model.PlayerActions;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhf.model.ReplayHeader;
import hu.belicza.andras.bwhfagent.view.ChartsTab;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.Utils;
import hu.belicza.andras.bwhfagent.view.charts.ChartsParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import swingwt.awt.BasicStroke;
import swingwt.awt.BorderLayout;
import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.Font;
import swingwt.awt.FontMetrics;
import swingwt.awt.Graphics;
import swingwt.awt.Graphics2D;
import swingwt.awt.GridLayout;
import swingwt.awt.LayoutManager;
import swingwt.awt.LayoutManager2;
import swingwt.awt.Stroke;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.KeyAdapter;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwt.awt.event.MouseAdapter;
import swingwt.awt.event.MouseEvent;
import swingwt.awt.event.MouseListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Box;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JSplitPane;
import swingwtx.swing.JTextArea;
import swingwtx.swing.JTextField;
import swingwtx.swing.border.Border;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class ChartsComponent
extends JPanel {
    private static final Color[] IN_GAME_COLORS = new Color[]{new Color(244, 4, 4), new Color(12, 72, 204), new Color(44, 180, 148), new Color(136, 64, 156), new Color(248, 140, 20), new Color(112, 48, 20), new Color(204, 224, 208), new Color(252, 252, 56), new Color(8, 128, 8), new Color(252, 252, 124), new Color(236, 196, 176), new Color(64, 104, 212), new Color(116, 164, 124), new Color(144, 144, 184), new Color(252, 252, 124), new Color(0, 228, 252)};
    private static final Color CHART_BACKGROUND_COLOR = Color.BLACK;
    private static final Color CHART_AXIS_COLOR = Color.YELLOW;
    private static final Color CHART_DEFAULT_COLOR = Color.WHITE;
    private static final Color CHART_ASSIST_LINES_COLOR = new Color(80, 80, 80);
    private static final Color CHART_AXIS_LABEL_COLOR = Color.CYAN;
    private static final Color CHART_PLAYER_DESCRIPTION_COLOR = Color.GREEN;
    private static final Color CHART_HACK_COLOR = Color.RED;
    private static final Color CHART_HACK_COLOR2 = Color.YELLOW;
    private static final Color CHART_MARKER_COLOR = new Color(150, 150, 255);
    private static final Font CHART_MAIN_FONT = new Font("Times", 1, 10);
    private static final Font CHART_AXIS_LABEL_FONT = new Font("Courier New", 0, 8);
    private static final Font HACK_MARKER_FONT = new Font("Courier New", 1, 13);
    private static final Font CHART_PART_TEXT_FONT = new Font("Courier New", 0, 8);
    private static final Stroke CHART_STROKE = new BasicStroke(2.0f, 1, 1);
    private static final Stroke CHART_REST_STROKE = new BasicStroke(1.0f);
    private static final int ASSIST_LINES_COUNT = 5;
    private static final int TIME_LABELS_COUNT = 8;
    private static final int AUTO_DISABLING_APM_LIMIT = 30;
    private final ChartsTab chartsTab;
    private final JPanel contentPanel = new JPanel((LayoutManager2)new BorderLayout());
    private final JPanel chartOptionsPanel = Utils.createWrapperPanel();
    private final JPanel playersPanel = Utils.createWrapperPanel();
    private Replay replay;
    private List<HackDescription> hackDescriptionList;
    private List<Integer> playerIndexToShowList;
    private static final Object[] DETAIL_LEVELS = new Object[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100};
    private static final Object[] DISPLAY_LEVELS = new Object[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final JComboBox apmChartDetailLevelComboBox = new JComboBox(DETAIL_LEVELS);
    private final JCheckBox showSelectHotkeysCheckBox = new JCheckBox("Show select hotkeys", Boolean.parseBoolean(Utils.settingsProperties.getProperty("showSelectHotkeys")));
    private final JComboBox buildOrderDisplayLevelComboBox = new JComboBox(DISPLAY_LEVELS);
    private final JCheckBox showUnitsOnBuildOrderCheckBox = new JCheckBox("Show units", Boolean.parseBoolean(Utils.settingsProperties.getProperty("showUnitsOnBuildOrder")));
    private final JCheckBox hideWorkerUnitsCheckBox = new JCheckBox("Hide worker units", Boolean.parseBoolean(Utils.settingsProperties.getProperty("hideWorkerUnits")));
    private final JComboBox strategyDisplayLevelComboBox = new JComboBox(DISPLAY_LEVELS);
    private final JComboBox overallApmChartDetailLevelComboBox = new JComboBox(DETAIL_LEVELS);
    private final JSplitPane splitPane = new JSplitPane(0, true);
    private final ArrayList<Object[]> actionList = new ArrayList();
    private final StringBuilder actionsListTextBuilder = new StringBuilder();
    private final JTextArea actionsListTextArea = new JTextArea();
    private final JTextField jumpToIterationTextField = new JTextField(1);
    private final JTextField searchTextField = new JTextField(1);
    private final JTextField filterTextField = new JTextField(1);
    private int markerPosition = -1;
    static int asdf = 0;

    public ChartsComponent(ChartsTab chartsTab) {
        this.setBackground(CHART_BACKGROUND_COLOR);
        this.setMaximumSize(Utils.getMaxDimension());
        this.chartsTab = chartsTab;
        this.buildConentGUI();
        this.apmChartDetailLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("apmChartDetailLevel")));
        this.buildOrderDisplayLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("buildOrderDisplayLevels")));
        this.strategyDisplayLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("strategyDisplayLevels")));
        this.overallApmChartDetailLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("overallApmChartDetailLevel")));
    }

    private void buildConentGUI() {
        JPanel controlPanel = new JPanel((LayoutManager2)new BorderLayout());
        this.chartOptionsPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"Selected chart's settings:"));
        controlPanel.add((Component)this.chartOptionsPanel, (Object)"North");
        controlPanel.add((Component)this.playersPanel, (Object)"Center");
        this.contentPanel.add((Component)controlPanel, (Object)"North");
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                ChartsComponent.this.syncMarkerFromChartToActionList(event.getX());
                ChartsComponent.this.repaint();
            }
        });
        this.splitPane.setTopComponent((Component)Utils.wrapInBorderLayoutPanel((JComponent)this));
        Box actionListBox = Box.createHorizontalBox();
        this.actionsListTextArea.setFont(new Font("Courier New", 0, 8));
        this.actionsListTextArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (!event.isShiftDown() && !event.isControlDown()) {
                    ChartsComponent.this.syncMarkerFromActionListToChart();
                }
            }
        });
        this.actionsListTextArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (event.getButton() == 1) {
                    ChartsComponent.this.syncMarkerFromActionListToChart();
                }
            }
        });
        this.actionsListTextArea.setEditable(false);
        this.actionsListTextArea.setBackground(Color.WHITE);
        this.actionsListTextArea.setForeground(Color.BLACK);
        actionListBox.add((Component)new JScrollPane((Component)this.actionsListTextArea));
        Box optionsBox = Box.createVerticalBox();
        JPanel actionListOptionsPanel = new JPanel((LayoutManager)new GridLayout(3, 2));
        actionListOptionsPanel.add((Component)new JLabel("Jump to iteration:"));
        this.jumpToIterationTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (ChartsComponent.this.replay != null && event.getKeyCode() == 10) {
                    try {
                        int iteration = Integer.parseInt(ChartsComponent.this.jumpToIterationTextField.getText());
                        int index = ChartsComponent.this.searchActionForIteration(iteration);
                        ChartsComponent.this.actionsListTextArea.setCaretPosition(ChartsComponent.this.actionsListTextArea.getText().indexOf(((Action)((Object[])ChartsComponent.this.actionList.get(index))[0]).toString((String)((Object[])ChartsComponent.this.actionList.get(index))[1], ((ChartsComponent)ChartsComponent.this).chartsTab.displayActionsInSecondsCheckBox.isSelected())) + 1);
                        ChartsComponent.this.syncMarkerFromActionListToChart();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        actionListOptionsPanel.add((Component)this.jumpToIterationTextField);
        actionListOptionsPanel.add((Component)new JLabel("Search text:"));
        this.searchTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (ChartsComponent.this.replay != null && event.getKeyCode() == 10 && ChartsComponent.this.searchTextField.getText().length() > 0) {
                    int foundIndex;
                    if (ChartsComponent.this.actionsListTextBuilder.length() == 0) {
                        ChartsComponent.this.actionsListTextBuilder.append(ChartsComponent.this.actionsListTextArea.getText().toLowerCase());
                    }
                    if ((foundIndex = ChartsComponent.this.actionsListTextBuilder.indexOf(ChartsComponent.this.searchTextField.getText().toLowerCase(), ChartsComponent.indexOfLineEnd(ChartsComponent.this.actionsListTextBuilder, ChartsComponent.this.actionsListTextArea.getCaretPosition()))) < 0) {
                        foundIndex = ChartsComponent.this.actionsListTextBuilder.indexOf(ChartsComponent.this.searchTextField.getText().toLowerCase(), ChartsComponent.indexOfLineEnd(ChartsComponent.this.actionsListTextBuilder, 0));
                    }
                    if (foundIndex >= 0) {
                        ChartsComponent.this.actionsListTextArea.setCaretPosition(foundIndex);
                        ChartsComponent.this.syncMarkerFromActionListToChart();
                    }
                }
            }
        });
        actionListOptionsPanel.add((Component)this.searchTextField);
        actionListOptionsPanel.add((Component)new JLabel("Filter actions:"));
        this.filterTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    ChartsComponent.this.loadPlayerActionsIntoList();
                }
            }
        });
        actionListOptionsPanel.add((Component)this.filterTextField);
        optionsBox.add((Component)Utils.wrapInPanel((JComponent)actionListOptionsPanel));
        JPanel clearFilterButtonPanel = new JPanel((LayoutManager)new GridLayout(1, 2));
        clearFilterButtonPanel.add((Component)new JLabel());
        JButton clearFilterButton = new JButton("Clear filter", (Icon)IconResourceManager.ICON_UNDO);
        clearFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ChartsComponent.this.filterTextField.setText("");
                ChartsComponent.this.loadPlayerActionsIntoList();
            }
        });
        clearFilterButtonPanel.add((Component)clearFilterButton);
        optionsBox.add((Component)clearFilterButtonPanel);
        JLabel verticalFillerComponent = new JLabel();
        verticalFillerComponent.setMaximumSize(new Dimension(1, Integer.MAX_VALUE));
        optionsBox.add((Component)verticalFillerComponent);
        actionListBox.add((Component)optionsBox);
        this.splitPane.setBottomComponent((Component)actionListBox);
        this.contentPanel.add((Component)this.splitPane, (Object)"Center");
        ChangeListener repainterChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                ChartsComponent.this.repaint();
            }
        };
        this.apmChartDetailLevelComboBox.addChangeListener(repainterChangeListener);
        this.showSelectHotkeysCheckBox.addChangeListener(repainterChangeListener);
        this.buildOrderDisplayLevelComboBox.addChangeListener(repainterChangeListener);
        this.showUnitsOnBuildOrderCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                ChartsComponent.this.hideWorkerUnitsCheckBox.setEnabled(ChartsComponent.this.showUnitsOnBuildOrderCheckBox.isSelected());
            }
        });
        this.showUnitsOnBuildOrderCheckBox.addChangeListener(repainterChangeListener);
        this.hideWorkerUnitsCheckBox.addChangeListener(repainterChangeListener);
        this.hideWorkerUnitsCheckBox.setEnabled(this.showUnitsOnBuildOrderCheckBox.isSelected());
        this.strategyDisplayLevelComboBox.addChangeListener(repainterChangeListener);
        this.overallApmChartDetailLevelComboBox.addChangeListener(repainterChangeListener);
    }

    private void syncMarkerFromChartToActionList(int x) {
        if (this.replay == null || this.playerIndexToShowList.isEmpty()) {
            return;
        }
        int iteration = ChartsParams.getIterationForX(x, this.replay.replayHeader.gameFrames, (JComponent)this);
        if (iteration >= 0) {
            this.markerPosition = x;
            int index = this.searchActionForIteration(iteration);
            if (iteration >= 0 && index >= 0) {
                String actionString = ((Action)this.actionList.get(index)[0]).toString((String)this.actionList.get(index)[1], this.chartsTab.displayActionsInSecondsCheckBox.isSelected());
                int actionCaretPosition = this.actionsListTextArea.getText().indexOf(actionString);
                this.actionsListTextArea.setCaretPosition(actionCaretPosition);
                this.actionsListTextArea.setSelectionStart(-1);
                this.actionsListTextArea.setSelectionEnd(-1);
                this.actionsListTextArea.setSelectionEnd(actionCaretPosition + actionString.length());
                this.actionsListTextArea.setSelectionStart(actionCaretPosition);
            }
        }
    }

    private int searchActionForIteration(int iteration) {
        if (this.actionList.isEmpty()) {
            return -1;
        }
        int minIndex = 0;
        int maxIndex = this.actionList.size() - 1;
        if (iteration >= ((Action)this.actionList.get((int)maxIndex)[0]).iteration) {
            return maxIndex;
        }
        int lastIndex = -1;
        while (true) {
            int index = (minIndex + maxIndex) / 2;
            int iteration2 = ((Action)this.actionList.get((int)index)[0]).iteration;
            if (iteration2 == iteration || lastIndex == index) {
                return index;
            }
            if (iteration < iteration2) {
                maxIndex = index;
            } else {
                minIndex = index;
            }
            lastIndex = index;
        }
    }

    private void syncMarkerFromActionListToChart() {
        int maxTime;
        int time;
        String actionListText = this.actionsListTextArea.getText();
        if (this.actionsListTextArea.getText().length() == 0) {
            return;
        }
        int caretPosition = this.actionsListTextArea.getCaretPosition();
        if (caretPosition < 0) {
            caretPosition = 0;
        }
        if (caretPosition >= actionListText.length()) {
            caretPosition = actionListText.length() - 1;
        }
        if (actionListText.charAt(caretPosition) == '\n') {
            --caretPosition;
        }
        int actionFirstPosition = ChartsComponent.indexOfLineStart(actionListText, caretPosition);
        int actionLastPosition = ChartsComponent.indexOfLineEnd(actionListText, caretPosition);
        this.actionsListTextArea.setSelectionStart(-1);
        this.actionsListTextArea.setSelectionEnd(-1);
        this.actionsListTextArea.setSelectionEnd(actionLastPosition);
        this.actionsListTextArea.setSelectionStart(actionFirstPosition);
        StringTokenizer timeTokenizer = new StringTokenizer(actionListText.substring(actionFirstPosition, actionLastPosition));
        if (this.chartsTab.displayActionsInSecondsCheckBox.isSelected()) {
            time = 3600 * Integer.parseInt(timeTokenizer.nextToken(":")) + 60 * Integer.parseInt(timeTokenizer.nextToken(":")) + Integer.parseInt(timeTokenizer.nextToken(": "));
            maxTime = this.replay.replayHeader.getDurationSeconds();
        } else {
            time = Integer.parseInt(timeTokenizer.nextToken());
            maxTime = this.replay.replayHeader.gameFrames;
        }
        this.markerPosition = ChartsParams.getXForTime(time, maxTime, (JComponent)this);
        this.repaint();
    }

    private static int indexOfLineStart(String text, int pos) {
        while (pos > 0 && text.charAt(pos) != '\n') {
            --pos;
        }
        if (text.charAt(pos) == '\n') {
            ++pos;
        }
        return pos;
    }

    private static int indexOfLineEnd(CharSequence text, int pos) {
        if (text instanceof String) {
            pos = ((String)text).indexOf(10, pos);
        } else if (text instanceof StringBuilder) {
            pos = ((StringBuilder)text).indexOf("\n", pos);
        } else {
            throw new IllegalArgumentException("Illegal text parameter, only String and StringBuilder are supported!");
        }
        if (pos < 0) {
            pos = text.length();
        }
        return pos;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void initializationEnded() {
        this.splitPane.setDividerLocation(0.78);
    }

    public void setChartType(ChartType chartType) {
        this.assignUsedProperties();
        while (this.chartOptionsPanel.getComponentCount() > 0) {
            this.chartOptionsPanel.remove(this.chartOptionsPanel.getComponentCount() - 1);
        }
        switch (chartType) {
            case APM: {
                this.chartOptionsPanel.add((Component)new JLabel("Detail level: "));
                this.chartOptionsPanel.add((Component)this.apmChartDetailLevelComboBox);
                this.chartOptionsPanel.add((Component)new JLabel(" pixels."));
                break;
            }
            case HOTKEYS: {
                this.chartOptionsPanel.add((Component)this.showSelectHotkeysCheckBox);
                break;
            }
            case BUILD_ORDER: {
                this.chartOptionsPanel.add((Component)new JLabel("Display levels: "));
                this.chartOptionsPanel.add((Component)this.buildOrderDisplayLevelComboBox);
                this.chartOptionsPanel.add((Component)new JLabel("\u00a0"));
                this.chartOptionsPanel.add((Component)this.showUnitsOnBuildOrderCheckBox);
                this.chartOptionsPanel.add((Component)this.hideWorkerUnitsCheckBox);
                break;
            }
            case STRATEGY: {
                this.chartOptionsPanel.add((Component)new JLabel("Display levels: "));
                this.chartOptionsPanel.add((Component)this.strategyDisplayLevelComboBox);
                break;
            }
            case OVERALL_APM: {
                this.chartOptionsPanel.add((Component)new JLabel("Detail level: "));
                this.chartOptionsPanel.add((Component)this.overallApmChartDetailLevelComboBox);
                this.chartOptionsPanel.add((Component)new JLabel(" pixels."));
            }
        }
        this.apmChartDetailLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("apmChartDetailLevel")));
        this.showSelectHotkeysCheckBox.setSelected(Boolean.parseBoolean(Utils.settingsProperties.getProperty("showSelectHotkeys")));
        this.showUnitsOnBuildOrderCheckBox.setSelected(Boolean.parseBoolean(Utils.settingsProperties.getProperty("showUnitsOnBuildOrder")));
        this.buildOrderDisplayLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("buildOrderDisplayLevels")));
        this.hideWorkerUnitsCheckBox.setSelected(Boolean.parseBoolean(Utils.settingsProperties.getProperty("hideWorkerUnits")));
        this.buildOrderDisplayLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("strategyDisplayLevels")));
        this.overallApmChartDetailLevelComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("overallApmChartDetailLevel")));
        this.contentPanel.validate();
        this.repaint();
    }

    public void setReplay(Replay replay) {
        this.replay = replay;
        this.markerPosition = -1;
        while (this.playersPanel.getComponentCount() > 1) {
            this.playersPanel.remove(this.playersPanel.getComponentCount() - 1);
        }
        if (replay != null) {
            this.hackDescriptionList = ReplayScanner.scanReplayForHacks(replay, false);
            final PlayerActions[] playerActions = replay.replayActions.players;
            if (this.playersPanel.getComponentCount() == 0) {
                this.playersPanel.add((Component)new JLabel("Players: "));
            }
            final Object[][] players = new Object[playerActions.length][2];
            ActionListener playerCheckBoxActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ChartsComponent.this.playerIndexToShowList.clear();
                    int i = 0;
                    while (i < players.length) {
                        if (((JCheckBox)players[i][0]).isSelected()) {
                            ChartsComponent.this.playerIndexToShowList.add((Integer)players[i][1]);
                        }
                        ++i;
                    }
                    ChartsComponent.this.repaint();
                    ChartsComponent.this.loadPlayerActionsIntoList();
                    ChartsComponent.this.syncMarkerFromChartToActionList(ChartsComponent.this.markerPosition);
                }
            };
            int autoDisablingActionsCountLimit = 30 * replay.replayHeader.getDurationSeconds() / 60;
            int i = 0;
            while (i < players.length) {
                players[i][0] = new JCheckBox(playerActions[i].playerName, !this.chartsTab.autoDisableInactivePlayersCheckBox.isSelected() || playerActions[i].actions.length > autoDisablingActionsCountLimit);
                players[i][1] = i;
                ((JCheckBox)players[i][0]).addActionListener(playerCheckBoxActionListener);
                ++i;
            }
            Arrays.sort(players, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] o1, Object[] o2) {
                    return -Integer.valueOf(playerActions[((Integer)o1[1]).intValue()].actions.length).compareTo(playerActions[((Integer)o2[1]).intValue()].actions.length);
                }
            });
            Object[][] objectArray = players;
            int n = players.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] player = objectArray[n2];
                this.playersPanel.add((Component)((JCheckBox)player[0]));
                ++n2;
            }
            this.playerIndexToShowList = new ArrayList<Integer>(players.length);
            playerCheckBoxActionListener.actionPerformed(null);
            this.contentPanel.validate();
        } else {
            this.hackDescriptionList = null;
            this.repaint();
            this.loadPlayerActionsIntoList();
        }
    }

    public void loadPlayerActionsIntoList() {
        String[][] filterGroups = this.createFilterGroups();
        this.actionList.clear();
        this.actionsListTextBuilder.setLength(0);
        if (this.replay != null) {
            PlayerActions[] playerActionss = this.replay.replayActions.players;
            int actionsCount = 0;
            for (int playerIndex : this.playerIndexToShowList) {
                actionsCount += playerActionss[playerIndex].actions.length;
            }
            this.actionList.ensureCapacity(actionsCount);
            for (int playerIndex : this.playerIndexToShowList) {
                String playerName = playerActionss[playerIndex].playerName;
                Action[] actionArray = playerActionss[playerIndex].actions;
                int n = playerActionss[playerIndex].actions.length;
                int n2 = 0;
                while (n2 < n) {
                    Action action = actionArray[n2];
                    if (filterGroups != null) {
                        String actionString = action.toString(playerName, this.chartsTab.displayActionsInSecondsCheckBox.isSelected()).toLowerCase();
                        String[][] stringArray = filterGroups;
                        int n3 = filterGroups.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String[] filterGroup = stringArray[n4];
                            boolean filterApplies = true;
                            String[] stringArray2 = filterGroup;
                            int n5 = filterGroup.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String filter = stringArray2[n6];
                                if (!actionString.contains(filter)) {
                                    filterApplies = false;
                                    break;
                                }
                                ++n6;
                            }
                            if (filterApplies) {
                                this.actionList.add(new Object[]{action, playerName});
                                break;
                            }
                            ++n4;
                        }
                    } else {
                        this.actionList.add(new Object[]{action, playerName});
                    }
                    ++n2;
                }
            }
            Collections.sort(this.actionList, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] action1, Object[] action2) {
                    return ((Action)action1[0]).compareTo((Action)action2[0]);
                }
            });
            boolean displayActionsInSeconds = this.chartsTab.displayActionsInSecondsCheckBox.isSelected();
            for (Object[] action : this.actionList) {
                this.actionsListTextBuilder.append(((Action)action[0]).toString((String)action[1], displayActionsInSeconds)).append('\n');
            }
            if (this.actionsListTextBuilder.length() > 0) {
                this.actionsListTextBuilder.setLength(this.actionsListTextBuilder.length() - 1);
            }
        }
        this.actionsListTextArea.setText(this.actionsListTextBuilder.toString());
        this.actionsListTextBuilder.setLength(0);
    }

    private String[][] createFilterGroups() {
        if (this.filterTextField.getText().length() == 0) {
            return null;
        }
        ArrayList filterGroupList = new ArrayList();
        StringTokenizer filterTokenizer = new StringTokenizer(this.filterTextField.getText().toLowerCase());
        ArrayList<String> filterGroup = null;
        while (filterTokenizer.hasMoreTokens()) {
            String filterToken = filterTokenizer.nextToken();
            if (filterToken.equals("or")) {
                filterGroup = null;
                continue;
            }
            if (filterToken.equals("and")) continue;
            if (filterGroup == null) {
                filterGroup = new ArrayList<String>(2);
                filterGroupList.add(filterGroup);
            }
            filterGroup.add(filterToken);
        }
        String[][] filterGroups = new String[filterGroupList.size()][];
        int i = 0;
        while (i < filterGroups.length) {
            filterGroups[i] = ((List)filterGroupList.get(i)).toArray(new String[0]);
            ++i;
        }
        return filterGroups;
    }

    public void paintComponent(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(CHART_BACKGROUND_COLOR);
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.replay != null && this.playerIndexToShowList.size() > 0) {
            ChartsParams chartsParams = new ChartsParams(this.chartsTab, this.replay.replayHeader.gameFrames, this.playerIndexToShowList.size(), (JComponent)this);
            switch ((ChartType)((Object)this.chartsTab.chartTypeComboBox.getSelectedItem())) {
                case APM: {
                    this.paintApmCharts(graphics, chartsParams, false);
                    break;
                }
                case HOTKEYS: {
                    this.paintHotkeysCharts(graphics, chartsParams);
                    break;
                }
                case BUILD_ORDER: {
                    this.paintBuildOrderCharts(graphics, chartsParams);
                    break;
                }
                case STRATEGY: {
                    this.paintStrategyCharts(graphics, chartsParams);
                    break;
                }
                case OVERALL_APM: {
                    this.paintApmCharts(graphics, chartsParams, true);
                }
            }
            if (this.markerPosition >= 0) {
                graphics.setColor(CHART_MARKER_COLOR);
                graphics.drawLine(this.markerPosition, 0, this.markerPosition, this.getHeight() - 1);
            }
        }
    }

    private void paintApmCharts(Graphics graphics, ChartsParams chartsParams, boolean overall) {
        int y1;
        int[] yPoints;
        int chartGranularity = (Integer)(overall ? this.overallApmChartDetailLevelComboBox : this.apmChartDetailLevelComboBox).getSelectedItem();
        if (this.getWidth() < chartGranularity) {
            return;
        }
        int chartPoints = chartsParams.maxXInChart / chartGranularity + 1;
        int[] xPoints = new int[chartPoints + 1];
        int[][] yPointss = new int[chartsParams.playersCount][chartPoints + 1];
        int pointIndex = 0;
        int x = chartsParams.x1;
        while (pointIndex < xPoints.length) {
            xPoints[pointIndex] = x;
            ++pointIndex;
            x += chartGranularity;
        }
        graphics.setFont(CHART_MAIN_FONT);
        graphics.setColor(CHART_AXIS_COLOR);
        graphics.drawString(overall ? "Overall APM" : "APM", 1, 0);
        int i = 0;
        while (i < chartsParams.playersCount) {
            PlayerActions playerActions = this.replay.replayActions.players[this.playerIndexToShowList.get(i)];
            yPoints = yPointss[i];
            int lastPointIndex = 1;
            Action[] actionArray = playerActions.actions;
            int n = playerActions.actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                try {
                    pointIndex = 1 + action.iteration * chartPoints / chartsParams.frames;
                    if (overall && lastPointIndex < pointIndex) {
                        int actionsCount = yPoints[lastPointIndex];
                        while (lastPointIndex < pointIndex) {
                            yPoints[++lastPointIndex] = actionsCount;
                        }
                    }
                    int n3 = pointIndex;
                    yPoints[n3] = yPoints[n3] + 1;
                }
                catch (ArrayIndexOutOfBoundsException actionsCount) {
                    // empty catch block
                }
                ++n2;
            }
            ++i;
        }
        int[] maxActionss = new int[chartsParams.playersCount];
        int i2 = 0;
        while (i2 < chartsParams.playersCount) {
            yPoints = yPointss[i2];
            int maxActions = maxActionss[i2];
            pointIndex = yPoints.length - 1;
            while (pointIndex > 0) {
                int actionsInDomain;
                int n;
                if (overall) {
                    int n4 = pointIndex;
                    n = yPoints[n4] = yPoints[n4] / pointIndex;
                } else {
                    n = actionsInDomain = yPoints[pointIndex];
                }
                if (maxActions < actionsInDomain) {
                    maxActions = actionsInDomain;
                }
                --pointIndex;
            }
            if (chartsParams.allPlayersOnOneChart) {
                int j = 0;
                while (j < maxActionss.length) {
                    if (maxActions > maxActionss[j]) {
                        maxActionss[j] = maxActions;
                    }
                    ++j;
                }
            } else {
                maxActionss[i2] = maxActions;
            }
            ++i2;
        }
        int maxY = chartsParams.maxYInChart;
        int i3 = 0;
        while (i3 < chartsParams.playersCount) {
            int[] yPoints2 = yPointss[i3];
            int maxActions = maxActionss[i3];
            y1 = chartsParams.getY1ForChart(i3);
            if (maxActions > 0) {
                pointIndex = yPoints2.length - 1;
                while (pointIndex > 0) {
                    yPoints2[pointIndex] = y1 + maxY - yPoints2[pointIndex] * maxY / maxActions;
                    --pointIndex;
                }
                yPoints2[0] = yPoints2[1];
            } else {
                Arrays.fill(yPoints2, y1 + maxY);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < chartsParams.playersCount) {
            PlayerActions playerActions = this.replay.replayActions.players[this.playerIndexToShowList.get(i3)];
            int[] yPoints3 = yPointss[i3];
            y1 = chartsParams.getY1ForChart(i3);
            Color inGameColor = this.getPlayerInGameColor(playerActions);
            this.drawAxisAndTimeLabels(graphics, chartsParams, i3);
            if (!chartsParams.allPlayersOnOneChart || i3 == 0) {
                graphics.setFont(CHART_AXIS_LABEL_FONT);
                int maxApm = maxActionss[i3] > 0 ? maxActionss[i3] * (chartPoints - 1) * 60 / Math.max(ReplayHeader.convertFramesToSeconds(chartsParams.frames), 1) : 5;
                int j = 0;
                while (j <= 5) {
                    int y = y1 + chartsParams.maxYInChart - chartsParams.maxYInChart * j / 5;
                    int apm = maxApm * j / 5;
                    graphics.setColor(CHART_AXIS_LABEL_COLOR);
                    graphics.drawString(String.valueOf(apm < 100 ? (apm < 10 ? "  " : " ") : "") + apm, 1, y - 7);
                    if (j > 0) {
                        graphics.setColor(CHART_ASSIST_LINES_COLOR);
                        graphics.drawLine(chartsParams.x1 + 1, y, chartsParams.x1 + chartsParams.maxXInChart, y);
                    }
                    ++j;
                }
            }
            Color chartColor = inGameColor == null ? CHART_DEFAULT_COLOR : inGameColor;
            graphics.setColor(chartColor);
            ((Graphics2D)graphics).setStroke(CHART_STROKE);
            graphics.drawPolyline(xPoints, yPoints3, xPoints.length - 1);
            ((Graphics2D)graphics).setStroke(CHART_REST_STROKE);
            if (this.hackDescriptionList != null) {
                graphics.setColor(chartColor.getRed() > 200 && chartColor.getGreen() < 100 && chartColor.getBlue() < 100 ? CHART_HACK_COLOR2 : CHART_HACK_COLOR);
                graphics.setFont(HACK_MARKER_FONT);
                for (HackDescription hackDescription : this.hackDescriptionList) {
                    if (!hackDescription.playerName.equalsIgnoreCase(playerActions.playerName)) continue;
                    pointIndex = hackDescription.iteration * chartPoints / chartsParams.frames;
                    float position = (float)(hackDescription.iteration - pointIndex * chartsParams.frames / chartPoints) * (float)chartPoints / (float)chartsParams.frames;
                    graphics.drawString("!", this.interpolate(xPoints[pointIndex], xPoints[pointIndex + 1], position) - 4, this.interpolate(yPoints3[pointIndex], yPoints3[pointIndex + 1], position) - 18, true);
                }
            }
            this.drawPlayerDescription(graphics, chartsParams, i3, inGameColor);
            ++i3;
        }
    }

    private int interpolate(int x1, int x2, float position) {
        return x1 + (int)((float)(x2 - x1) * position);
    }

    private void paintHotkeysCharts(Graphics graphics, ChartsParams chartsParams) {
        boolean showSelectHotkeys = this.showSelectHotkeysCheckBox.isSelected();
        int i = 0;
        while (i < chartsParams.playersCount) {
            PlayerActions playerActions = this.replay.replayActions.players[this.playerIndexToShowList.get(i)];
            int y1 = chartsParams.getY1ForChart(i);
            Color inGameColor = this.getPlayerInGameColor(playerActions);
            Color chartColor = inGameColor == null ? CHART_DEFAULT_COLOR : inGameColor;
            this.drawAxisAndTimeLabels(graphics, chartsParams, i);
            graphics.setFont(CHART_PART_TEXT_FONT);
            Action[] actionArray = playerActions.actions;
            int n = playerActions.actions.length;
            int n2 = 0;
            while (n2 < n) {
                String[] params;
                boolean isHotkeyAssign;
                Action action = actionArray[n2];
                Color chartColor2 = new Color(~chartColor.getRed() & 0xFF, ~chartColor.getGreen() & 0xFF, ~chartColor.getBlue() & 0xFF);
                if (action.actionNameIndex == 19 && ((isHotkeyAssign = (params = action.parameters.split(","))[0].equals("Assign")) || showSelectHotkeys)) {
                    int hotkey = Integer.parseInt(params[1]) % 10;
                    if (isHotkeyAssign) {
                        ((Graphics2D)graphics).setBackground(chartColor);
                        graphics.setColor(chartColor2);
                    } else {
                        ((Graphics2D)graphics).setBackground(CHART_BACKGROUND_COLOR);
                        graphics.setColor(chartColor);
                    }
                    graphics.drawString(params[1], chartsParams.getXForIteration(action.iteration), y1 + hotkey * (chartsParams.maxYInChart - 14) / 9, !isHotkeyAssign);
                }
                ++n2;
            }
            ((Graphics2D)graphics).setBackground(CHART_BACKGROUND_COLOR);
            this.drawPlayerDescription(graphics, chartsParams, i, inGameColor);
            ++i;
        }
    }

    private void paintBuildOrderCharts(Graphics graphics, ChartsParams chartsParams) {
        boolean showUnits = this.showUnitsOnBuildOrderCheckBox.isSelected();
        int buildOrderDisplayLevels = (Integer)this.buildOrderDisplayLevelComboBox.getSelectedItem() - 1;
        boolean hideWorkerUnits = this.hideWorkerUnitsCheckBox.isSelected();
        FontMetrics fontMetrics = graphics.getFontMetrics(CHART_PART_TEXT_FONT);
        int i = 0;
        while (i < chartsParams.playersCount) {
            int playerIndex = this.playerIndexToShowList.get(i);
            PlayerActions playerActions = this.replay.replayActions.players[playerIndex];
            int y1 = chartsParams.getY1ForChart(i);
            int y2 = y1 + chartsParams.maxYInChart - 1;
            Color inGameColor = this.getPlayerInGameColor(playerActions);
            Color chartColor = inGameColor == null ? CHART_DEFAULT_COLOR : inGameColor;
            this.drawAxisAndTimeLabels(graphics, chartsParams, i);
            graphics.setFont(CHART_PART_TEXT_FONT);
            int buildOrderLevel = chartsParams.allPlayersOnOneChart ? buildOrderDisplayLevels - i * 2 : buildOrderDisplayLevels;
            while (buildOrderLevel < 0) {
                buildOrderLevel += buildOrderDisplayLevels;
            }
            Action[] actionArray = playerActions.actions;
            int n = playerActions.actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                graphics.setColor(chartColor);
                if (action.actionNameIndex == 12 || showUnits && (action.actionNameIndex == 31 || action.actionNameIndex == 35)) {
                    short unitId;
                    short s = unitId = action.actionNameIndex == 12 ? action.parameterBuildingNameIndex : action.parameterUnitNameIndex;
                    if (!hideWorkerUnits || unitId != 41 && unitId != 64 && unitId != 7) {
                        String buildingName = Action.UNIT_ID_NAME_MAP.get(unitId);
                        buildingName = buildingName == null ? "" : buildingName;
                        int x = chartsParams.getXForIteration(action.iteration);
                        int y = y1 + 14 + buildOrderLevel * (chartsParams.maxYInChart - 23) / buildOrderDisplayLevels;
                        graphics.drawLine(x, y, x, y2);
                        graphics.drawString(buildingName, x - fontMetrics.stringWidth(buildingName) / 2 - 4, y - 14, true);
                        if (--buildOrderLevel < 0) {
                            buildOrderLevel = buildOrderDisplayLevels;
                        }
                    }
                }
                ++n2;
            }
            this.drawPlayerDescription(graphics, chartsParams, i, inGameColor);
            ++i;
        }
    }

    private void paintStrategyCharts(Graphics graphics, ChartsParams chartsParams) {
        int strategyDisplayLevels = (Integer)this.strategyDisplayLevelComboBox.getSelectedItem() - 1;
        FontMetrics fontMetrics = graphics.getFontMetrics(CHART_PART_TEXT_FONT);
        int i = 0;
        while (i < chartsParams.playersCount) {
            int playerIndex = this.playerIndexToShowList.get(i);
            PlayerActions playerActions = this.replay.replayActions.players[playerIndex];
            int y1 = chartsParams.getY1ForChart(i);
            int y2 = y1 + chartsParams.maxYInChart - 1;
            Color inGameColor = this.getPlayerInGameColor(playerActions);
            Color chartColor = inGameColor == null ? CHART_DEFAULT_COLOR : inGameColor;
            this.drawAxisAndTimeLabels(graphics, chartsParams, i);
            graphics.setFont(CHART_PART_TEXT_FONT);
            int strategyLevel = chartsParams.allPlayersOnOneChart ? strategyDisplayLevels - i * 2 : strategyDisplayLevels;
            while (strategyLevel < 0) {
                strategyLevel += strategyDisplayLevels + 1;
            }
            Action[] actionArray = playerActions.actions;
            int n = playerActions.actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                graphics.setColor(chartColor);
                String strategyName = null;
                if (action.actionNameIndex == 40 || action.actionNameIndex == 41 || action.subactionNameIndex == 112) {
                    strategyName = "Drop";
                } else if (action.actionNameIndex == 12) {
                    if (action.parameterBuildingNameIndex == 131 || action.parameterBuildingNameIndex == 154 || action.parameterBuildingNameIndex == 106) {
                        strategyName = "Expand";
                    } else if (action.parameterBuildingNameIndex == 125 || action.parameterBuildingNameIndex == 162) {
                        strategyName = "Defense";
                    } else if (action.parameterBuildingNameIndex == 134) {
                        strategyName = "Nydus";
                    }
                } else if (action.actionNameIndex == 53 && action.parameterBuildingNameIndex == 146) {
                    strategyName = "Defense";
                } else if (action.subactionNameIndex == -113) {
                    strategyName = "Recall";
                } else if (action.subactionNameIndex == 126) {
                    strategyName = "Nuke";
                }
                if (strategyName != null) {
                    int x = chartsParams.getXForIteration(action.iteration);
                    int y = y1 + 14 + strategyLevel * (chartsParams.maxYInChart - 23) / strategyDisplayLevels;
                    graphics.drawLine(x, y, x, y2);
                    graphics.drawString(strategyName, x - fontMetrics.stringWidth(strategyName) / 2 - 4, y - 14, true);
                    if (--strategyLevel < 0) {
                        strategyLevel = strategyDisplayLevels;
                    }
                }
                ++n2;
            }
            this.drawPlayerDescription(graphics, chartsParams, i, inGameColor);
            ++i;
        }
    }

    private Color getPlayerInGameColor(PlayerActions playerActions) {
        Color inGameColor = null;
        if (this.chartsTab.allPlayersOnOneChartCheckBox.isSelected() || this.chartsTab.usePlayersColorsCheckBox.isSelected()) {
            try {
                int headerPlayerIndex = this.replay.replayHeader.getPlayerIndexByName(playerActions.playerName);
                inGameColor = IN_GAME_COLORS[this.replay.replayHeader.playerColors[headerPlayerIndex]];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inGameColor;
    }

    private void drawAxisAndTimeLabels(Graphics graphics, ChartsParams chartsParams, int chartIndex) {
        if (!chartsParams.allPlayersOnOneChart || chartIndex == 0) {
            int frames = this.replay.replayHeader.gameFrames;
            int y1 = chartsParams.getY1ForChart(chartIndex);
            graphics.setColor(CHART_AXIS_COLOR);
            graphics.drawLine(chartsParams.x1, y1, chartsParams.x1, y1 + chartsParams.chartHeight);
            graphics.drawLine(chartsParams.x1, y1 + chartsParams.maxYInChart, chartsParams.x1 + chartsParams.maxXInChart, y1 + chartsParams.maxYInChart);
            graphics.setColor(CHART_AXIS_LABEL_COLOR);
            graphics.setFont(CHART_AXIS_LABEL_FONT);
            int j = 0;
            while (j <= 8) {
                String timeString = ReplayHeader.formatFrames(frames * j / 8, new StringBuilder(), false).toString();
                int x = chartsParams.x1 + chartsParams.maxXInChart * j / 8 - (j == 0 ? 0 : (j == 8 ? timeString.length() * 7 : timeString.length() * 7 / 2));
                graphics.drawString(timeString, x, y1 + chartsParams.maxYInChart + 1);
                ++j;
            }
        }
    }

    private void drawPlayerDescription(Graphics graphics, ChartsParams chartsParams, int chartIndex, Color inGameColor) {
        graphics.setFont(CHART_MAIN_FONT);
        graphics.setColor(inGameColor == null ? CHART_PLAYER_DESCRIPTION_COLOR : inGameColor);
        graphics.drawString(this.replay.replayHeader.getPlayerDescription(this.replay.replayActions.players[this.playerIndexToShowList.get((int)chartIndex).intValue()].playerName), chartsParams.x1, chartsParams.getY1ForChart(chartIndex) + (chartsParams.allPlayersOnOneChart ? chartIndex * 14 - 22 : -12));
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("apmChartDetailLevel", Integer.toString(this.apmChartDetailLevelComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("showSelectHotkeys", Boolean.toString(this.showSelectHotkeysCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("buildOrderDisplayLevels", Integer.toString(this.buildOrderDisplayLevelComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("showUnitsOnBuildOrder", Boolean.toString(this.showUnitsOnBuildOrderCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("hideWorkerUnits", Boolean.toString(this.hideWorkerUnitsCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("strategyDisplayLevels", Integer.toString(this.strategyDisplayLevelComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("overallApmChartDetailLevel", Integer.toString(this.overallApmChartDetailLevelComboBox.getSelectedIndex()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChartType {
        APM("APM"),
        HOTKEYS("Hotkeys"),
        BUILD_ORDER("Build order"),
        STRATEGY("Strategy"),
        OVERALL_APM("Overall APM");

        private final String name;

        private ChartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

