/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhfagent.Consts;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.FlowLayout;
import swingwt.awt.LayoutManager;
import swingwt.awt.LayoutManager2;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTextField;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
    public static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("yyMMdd HHmmss");
    private static final int WAV_BUFFER_SIZE = 65536;
    private static final int FILE_COPY_BUFFER_SIZE = 4096;
    public static final FileFilter SWING_REPLAY_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".rep");
        }

        public String getDescription() {
            return "Replay files (*.rep)";
        }
    };
    public static final FileFilter SWING_TEXT_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".txt");
        }

        public String getDescription() {
            return "Text files (*.txt)";
        }
    };
    public static final Properties settingsProperties = new Properties(Consts.DEFAULT_SETTINGS_PROPERTIES);

    static {
        try {
            settingsProperties.load(new FileInputStream("settings.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveSettingsProperties() {
        try {
            settingsProperties.store(new FileOutputStream("settings.properties"), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Dimension getMaxDimension() {
        return new Dimension(10000, 10000);
    }

    public static JPanel createWrapperPanel() {
        JPanel panel = new JPanel();
        panel.setMaximumSize(Utils.getMaxDimension());
        return panel;
    }

    public static JPanel createWrapperPanelLeftAligned() {
        JPanel panel = new JPanel((LayoutManager)new FlowLayout(0));
        panel.setMaximumSize(Utils.getMaxDimension());
        return panel;
    }

    public static JPanel wrapInPanel(JComponent component) {
        JPanel panel = Utils.createWrapperPanel();
        panel.add((Component)component);
        return panel;
    }

    public static JPanel wrapInPanelLeftAligned(JComponent component) {
        JPanel panel = Utils.createWrapperPanelLeftAligned();
        panel.add((Component)component);
        return panel;
    }

    public static JPanel wrapInBorderLayoutPanel(JComponent component) {
        JPanel panel = new JPanel((LayoutManager2)new BorderLayout());
        panel.add((Component)component, (Object)"Center");
        return panel;
    }

    public static JButton createFileChooserButton(final Component parent, final JTextField targetTextField, final int fileSelectionMode, final FileFilter choosableFileFilter, final String[][] choosableFileFilterSWT, final Runnable taskOnApprove) {
        JButton chooseButton = new JButton("Choose...", (Icon)(fileSelectionMode == 1 ? IconResourceManager.ICON_FOLDER_CHOOSER : IconResourceManager.ICON_FILE_CHOOSER));
        chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(targetTextField.getText());
                if (choosableFileFilter != null) {
                    fileChooser.addChoosableFileFilter(choosableFileFilter);
                }
                if (choosableFileFilterSWT != null) {
                    fileChooser.setExtensionFilters(choosableFileFilterSWT[0], choosableFileFilterSWT[1]);
                }
                fileChooser.setFileSelectionMode(fileSelectionMode);
                if (fileChooser.showOpenDialog(parent) == 0) {
                    targetTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
                if (taskOnApprove != null) {
                    taskOnApprove.run();
                }
            }
        });
        return chooseButton;
    }

    public static void showURLInBrowser(String url) {
        try {
            boolean useOwnMethod = true;
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                    useOwnMethod = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (useOwnMethod) {
                String[] cmdArray = null;
                if (SwingWTUtils.isWindows()) {
                    cmdArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
                } else {
                    String[] browsers;
                    String[] stringArray = browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    int n = browsers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String browser = stringArray[n2];
                        if (Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0) {
                            cmdArray = new String[]{browser, url};
                            break;
                        }
                        ++n2;
                    }
                }
                if (cmdArray != null) {
                    Runtime.getRuntime().exec(cmdArray);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public static String readVersionStringFromStream(InputStream inputStream) {
        String string;
        BufferedReader bufferedReader;
        block12: {
            bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            string = bufferedReader.readLine();
            if (bufferedReader == null) break block12;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (Exception e) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static String formatNanoTimeAmount(long nanoTimeAmount) {
        long ms = nanoTimeAmount / 1000000L;
        String formattedText = String.valueOf(ms % 1000L) + " ms";
        long sec = ms / 1000L;
        if (sec > 0L) {
            formattedText = String.valueOf(sec % 60L) + " sec " + formattedText;
            long min = sec / 60L;
            if (min > 0L) {
                formattedText = String.valueOf(min % 60L) + " min " + formattedText;
                long hours = min / 60L;
                if (hours > 0L) {
                    formattedText = String.valueOf(hours) + " hour(s) " + formattedText;
                }
            }
        }
        return formattedText;
    }

    public static boolean playWavFile(File wavFile, boolean waitPlayEnd) {
        try {
            final AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(wavFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            final SourceDataLine audioLine = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, audioFormat));
            audioLine.open(audioFormat);
            if (audioLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl volume = (FloatControl)audioLine.getControl(FloatControl.Type.MASTER_GAIN);
                volume.setValue((float)(20.0 * Math.log10((double)MainFrame.getInstance().generalSettingsTab.soundVolumeSlider.getValue() / 100.0)));
            }
            Thread wavPlayerThread = new Thread(){

                public void run() {
                    try {
                        try {
                            int bytesRead;
                            audioLine.start();
                            byte[] buffer = new byte[65536];
                            while ((bytesRead = audioInputStream.read(buffer)) > 0) {
                                audioLine.write(buffer, 0, bytesRead);
                            }
                        }
                        catch (Exception exception) {
                            audioLine.drain();
                            audioLine.close();
                        }
                    }
                    finally {
                        audioLine.drain();
                        audioLine.close();
                    }
                }
            };
            wavPlayerThread.start();
            if (waitPlayEnd) {
                wavPlayerThread.join();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean copyFile(File sourceFile, File destinationFolder, String destinationFileName) {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        if (destinationFolder.exists() && destinationFolder.isDirectory()) {
            return Utils.copyFile(sourceFile, new File(destinationFolder, destinationFileName));
        }
        return false;
    }

    public static boolean copyFile(File sourceFile, File destinationFile) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Boolean checkAuthorizationKey(String key) {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(new URL("http://94.199.240.39/hackerdb/hackers?op=chk&key=" + URLEncoder.encode(key, "UTF-8")).openStream()));
            return Boolean.parseBoolean(input.readLine());
        }
        catch (Exception e) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static String sendHackerReport(String key, int gateway, int gameEngine, String mapName, String replayMd5, long replaySaveTime, Set<String> playerNameSet) {
        BufferedReader input = null;
        try {
            StringBuilder reportURLBuilder = new StringBuilder("http://94.199.240.39/hackerdb/hackers");
            reportURLBuilder.append('?').append("op").append('=').append("rep").append('&').append("key").append('=').append(URLEncoder.encode(key, "UTF-8")).append('&').append("gat").append('=').append(gateway).append('&').append("gen").append('=').append(gameEngine).append('&').append("mpn").append('=').append(URLEncoder.encode(mapName, "UTF-8")).append('&').append("md5").append('=').append(replayMd5).append('&').append("rst").append('=').append(replaySaveTime).append('&').append("agv").append('=').append(URLEncoder.encode(MainFrame.getInstance().applicationVersion, "UTF-8"));
            int i = 0;
            for (String playerName : playerNameSet) {
                reportURLBuilder.append('&').append("pln").append(i++).append('=').append(URLEncoder.encode(playerName, "UTF-8"));
            }
            input = new BufferedReader(new InputStreamReader(new URL(reportURLBuilder.toString()).openStream()));
            String message = input.readLine();
            return message.equals("OK") ? null : message;
        }
        catch (Exception e) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "Error connecting to the BWHF data base server!";
        }
    }

    public static void editFile(String fileName) {
        if (fileName.length() == 0) {
            return;
        }
        String editorProgram = MainFrame.getInstance().generalSettingsTab.editorProgramTextField.getText();
        if (editorProgram.length() > 0) {
            try {
                Runtime.getRuntime().exec(new String[]{editorProgram, fileName});
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static String calculateFileMd5(File file) {
        String string;
        FileInputStream input;
        block14: {
            int bytesRead;
            input = null;
            MessageDigest md = MessageDigest.getInstance("MD5");
            input = new FileInputStream(file);
            byte[] buffer = new byte[16384];
            while ((bytesRead = input.read(buffer)) > 0) {
                md.update(buffer, 0, bytesRead);
            }
            byte[] md5Bytes = md.digest();
            StringBuilder hexBuilder = new StringBuilder(md5Bytes.length * 2);
            byte[] byArray = md5Bytes;
            int n = md5Bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                hexBuilder.append(Integer.toHexString((b & 0xFF) >> 4)).append(Integer.toHexString(b & 0xF));
                ++n2;
            }
            string = hexBuilder.toString();
            if (input == null) break block14;
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (Exception e) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "";
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

