/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.LoggedTab;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.Utils;
import hu.belicza.andras.bwhfagent.view.textrecognition.CharDef;
import hu.belicza.andras.bwhfagent.view.textrecognition.TextRecognizer;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Font;
import swingwt.awt.GridBagConstraints;
import swingwt.awt.GridBagLayout;
import swingwt.awt.LayoutManager2;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.BorderFactory;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTextField;
import swingwtx.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerCheckerTab
extends LoggedTab {
    private static final long TIME_BETWEEN_CHECKS_FOR_NEED_OF_UPDATE = 10000L;
    private static final long MS_IN_AN_HOUR = 3600000L;
    private static final String UPDATE_NOW_BUTTON_TEXT = "Update now";
    private static final String HACKER_LIST_CACHE_FILE_NAME = "BWHF_hacker_list_cache.txt";
    private static final File HACKER_LIST_DIRECTORY = new File("Hacker list cache");
    private static final File HACKER_LIST_CACHE_FILE = new File("Hacker list cache", "BWHF_hacker_list_cache.txt");
    private JPanel settingsPanel;
    protected final JCheckBox playerCheckerEnabledCheckBox = new JCheckBox("Enable checking players in the game lobby when pressing the 'Print Screen' key", Boolean.parseBoolean(Utils.settingsProperties.getProperty("playerCheckerEnabled")));
    private final JComboBox hackerListUpdateIntervalComboBox = new JComboBox(new Object[]{1, 2, 6, 12, 24, 48});
    private final JLabel hackerListLastUpdatedLabel = new JLabel();
    private final JButton updateNowButton = new JButton("Update now", (Icon)IconResourceManager.ICON_DATABASE_REFRESH);
    private final JCheckBox includeCustomPlayerListCheckBox = new JCheckBox("Include this custom player list:", Boolean.parseBoolean(Utils.settingsProperties.getProperty("includeCustomPlayerList")));
    private final JTextField customPlayerListFileTextField = new JTextField(Utils.settingsProperties.getProperty("customPlayerListFile"));
    private final JButton reloadButton = new JButton("Reload", (Icon)IconResourceManager.ICON_ARROW_REFRESH);
    private final JCheckBox sayCleanCheckBox = new JCheckBox("Say \"clean\" if no hackers found", Boolean.parseBoolean(Utils.settingsProperties.getProperty("sayClean")));
    private final JCheckBox deleteGameLobbyScreenshotsCheckBox = new JCheckBox("Delete game lobby screenshots after checking players", Boolean.parseBoolean(Utils.settingsProperties.getProperty("deleteGameLobbyScreenshots")));
    private final JCheckBox echoRecognizedPlayerNamesCheckBox = new JCheckBox("Echo recognized player names in the log below", Boolean.parseBoolean(Utils.settingsProperties.getProperty("echoRecognizedPlayerNames")));
    private final Map<Integer, Set<String>> gatewayBwhfHackerSetMap = new HashMap<Integer, Set<String>>();
    private final Map<Integer, Set<String>> gatewayCustomPlayerSetMap = new HashMap<Integer, Set<String>>();
    private volatile long lastUpdateTime = HACKER_LIST_CACHE_FILE.lastModified();

    public PlayerCheckerTab() {
        super("Player checker", (Icon)IconResourceManager.ICON_PLAYER_CHECKER, "player_checker.log");
        this.buildGUI();
        this.hackerListUpdateIntervalComboBox.setSelectedIndex(Integer.parseInt(Utils.settingsProperties.getProperty("hackerListUpdateInterval")));
        this.refreshLastUpdatedLabel();
        this.reloadPlayerList(HACKER_LIST_CACHE_FILE, this.gatewayBwhfHackerSetMap);
        this.includeCustomPlayerListCheckBox.doClick();
        CharDef.class.toString();
        this.startCacheAutoUpdater();
    }

    @Override
    protected void buildGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.settingsPanel = new JPanel((LayoutManager2)gridBagLayout);
        this.settingsPanel.setBorder((Border)BorderFactory.createTitledBorder((String)"Settings:"));
        constraints.fill = 1;
        constraints.gridwidth = 0;
        JPanel wrapperPanel = Utils.wrapInPanel((JComponent)this.playerCheckerEnabledCheckBox);
        gridBagLayout.setConstraints((Component)wrapperPanel, constraints);
        this.settingsPanel.add((Component)wrapperPanel);
        constraints.gridwidth = 1;
        JLabel label = new JLabel("Automatically update hacker list cache in every\u00a0");
        gridBagLayout.setConstraints((Component)label, constraints);
        this.settingsPanel.add((Component)label);
        constraints.gridwidth = 1;
        gridBagLayout.setConstraints((Component)this.hackerListUpdateIntervalComboBox, constraints);
        this.settingsPanel.add((Component)this.hackerListUpdateIntervalComboBox);
        constraints.gridwidth = 0;
        label = new JLabel("\u00a0hours.");
        gridBagLayout.setConstraints((Component)label, constraints);
        this.settingsPanel.add((Component)label);
        constraints.gridwidth = 1;
        label = new JLabel("Hacker list cache last updated at:");
        gridBagLayout.setConstraints((Component)label, constraints);
        this.settingsPanel.add((Component)label);
        gridBagLayout.setConstraints((Component)this.hackerListLastUpdatedLabel, constraints);
        this.settingsPanel.add((Component)this.hackerListLastUpdatedLabel);
        constraints.gridwidth = 0;
        this.updateNowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PlayerCheckerTab.this.updateHackerList();
            }
        });
        gridBagLayout.setConstraints((Component)this.updateNowButton, constraints);
        this.settingsPanel.add((Component)this.updateNowButton);
        constraints.gridwidth = 1;
        this.includeCustomPlayerListCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PlayerCheckerTab.this.reloadButton.setEnabled(PlayerCheckerTab.this.includeCustomPlayerListCheckBox.isSelected());
                PlayerCheckerTab.this.reloadButton.doClick();
            }
        });
        gridBagLayout.setConstraints((Component)this.includeCustomPlayerListCheckBox, constraints);
        this.settingsPanel.add((Component)this.includeCustomPlayerListCheckBox);
        gridBagLayout.setConstraints((Component)this.customPlayerListFileTextField, constraints);
        this.settingsPanel.add((Component)this.customPlayerListFileTextField);
        constraints.gridwidth = 0;
        wrapperPanel = new JPanel((LayoutManager2)new BorderLayout());
        JButton button = Utils.createFileChooserButton((Component)this.getContent(), this.customPlayerListFileTextField, 0, Utils.SWING_TEXT_FILE_FILTER, new String[][]{{"*.txt", "*.*"}, {"Text files (*.txt)", "All files (*.*)"}}, new Runnable(){

            public void run() {
                File selectedFile = new File(PlayerCheckerTab.this.customPlayerListFileTextField.getText());
                if (selectedFile.getAbsolutePath().equals(new File("sounds/" + selectedFile.getName()).getAbsolutePath())) {
                    PlayerCheckerTab.this.customPlayerListFileTextField.setText("sounds/" + selectedFile.getName());
                }
            }
        });
        wrapperPanel.add((Component)button, (Object)"West");
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!PlayerCheckerTab.this.includeCustomPlayerListCheckBox.isSelected() || PlayerCheckerTab.this.customPlayerListFileTextField.getText().length() == 0) {
                    PlayerCheckerTab.this.gatewayCustomPlayerSetMap.clear();
                } else {
                    PlayerCheckerTab.this.reloadPlayerList(new File(PlayerCheckerTab.this.customPlayerListFileTextField.getText()), PlayerCheckerTab.this.gatewayCustomPlayerSetMap);
                }
            }
        });
        wrapperPanel.add((Component)this.reloadButton, (Object)"Center");
        button = new JButton("Edit", (Icon)IconResourceManager.ICON_EDIT);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Utils.editFile(PlayerCheckerTab.this.customPlayerListFileTextField.getText());
            }
        });
        wrapperPanel.add((Component)button, (Object)"East");
        gridBagLayout.setConstraints((Component)wrapperPanel, constraints);
        this.settingsPanel.add((Component)wrapperPanel);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.sayCleanCheckBox, constraints);
        this.settingsPanel.add((Component)this.sayCleanCheckBox);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.deleteGameLobbyScreenshotsCheckBox, constraints);
        this.settingsPanel.add((Component)this.deleteGameLobbyScreenshotsCheckBox);
        constraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.echoRecognizedPlayerNamesCheckBox, constraints);
        this.settingsPanel.add((Component)this.echoRecognizedPlayerNamesCheckBox);
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.settingsPanel));
        JLabel noteLabel = new JLabel("Note that you will only be notified of players reported with the gateway set on your autoscan tab! (Always keep it synchronized with the gateway you play on.)");
        noteLabel.setFont(new Font("Default", 1, 9));
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)noteLabel));
        super.buildGUI();
    }

    public synchronized File[] checkPlayers(File[] screenshotFiles) {
        ArrayList<File> remainedScreenshotFileList = new ArrayList<File>(screenshotFiles.length);
        int gateway = MainFrame.getInstance().autoscanTab.gatewayComboBox.getSelectedIndex() - 1;
        Set<String> bwhfHackerSet = this.gatewayBwhfHackerSetMap.get(gateway);
        Set<String> customPlayerNameSet = this.gatewayCustomPlayerSetMap.get(gateway);
        File[] fileArray = screenshotFiles;
        int n = screenshotFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File screenshotFile = fileArray[n2];
            BufferedImage image = null;
            try {
                image = ImageIO.read(screenshotFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image == null || !TextRecognizer.isGameLobbyScreenshot(image)) {
                remainedScreenshotFileList.add(screenshotFile);
            } else {
                this.logMessage("", false);
                this.logMessage("Game lobby screenshot detected, proceeding to check...");
                String[] playerNames = TextRecognizer.readPlayerNamesFromGameLobbyImage(image);
                if (this.echoRecognizedPlayerNamesCheckBox.isSelected()) {
                    StringBuilder playerNamesBuilder = new StringBuilder();
                    String[] stringArray = playerNames;
                    int n3 = playerNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String playerName = stringArray[n4];
                        if (playerName != null) {
                            if (playerNamesBuilder.length() > 0) {
                                playerNamesBuilder.append(", ");
                            }
                            playerNamesBuilder.append(playerName);
                        }
                        ++n4;
                    }
                    this.logMessage("Recognized player names in game lobby: " + playerNamesBuilder.toString());
                }
                boolean foundHacker = false;
                int i = 0;
                while (i < playerNames.length) {
                    String playerName = playerNames[i];
                    if (playerName != null) {
                        String playerNamePermutation;
                        String[] playerNamePermutations = PlayerCheckerTab.generatePlayerNamePermutations(playerName);
                        boolean exactMatch = playerNamePermutations.length == 1;
                        boolean isHacker = false;
                        String[] stringArray = playerNamePermutations;
                        int n5 = playerNamePermutations.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            playerNamePermutation = stringArray[n6];
                            if (bwhfHackerSet != null && bwhfHackerSet.contains(playerNamePermutation)) {
                                foundHacker = true;
                                isHacker = true;
                                this.logMessage("Found " + (exactMatch ? "" : "possible ") + "hacker player in game lobby: " + playerName);
                                Utils.playWavFile(new File("sounds", exactMatch ? "hacker_at_slot.wav" : "possible_hacker_at_slot.wav"), true);
                                Utils.playWavFile(new File("sounds", String.valueOf(i + 1) + ".wav"), true);
                                break;
                            }
                            ++n6;
                        }
                        if (!isHacker) {
                            stringArray = playerNamePermutations;
                            n5 = playerNamePermutations.length;
                            n6 = 0;
                            while (n6 < n5) {
                                playerNamePermutation = stringArray[n6];
                                if (customPlayerNameSet != null && customPlayerNameSet.contains(playerNamePermutation)) {
                                    foundHacker = true;
                                    this.logMessage("Found " + (exactMatch ? "" : "possible ") + "custom listed player in game lobby: " + playerName);
                                    Utils.playWavFile(new File("sounds", exactMatch ? "custom_at_slot.wav" : "possible_custom_at_slot.wav"), true);
                                    Utils.playWavFile(new File("sounds", String.valueOf(i + 1) + ".wav"), true);
                                    break;
                                }
                                ++n6;
                            }
                        }
                    }
                    ++i;
                }
                if (!foundHacker && this.sayCleanCheckBox.isSelected()) {
                    Utils.playWavFile(new File("sounds", "clean.wav"), true);
                }
                this.logMessage("Player check finished.");
                if (this.deleteGameLobbyScreenshotsCheckBox.isSelected()) {
                    screenshotFile.delete();
                } else {
                    remainedScreenshotFileList.add(screenshotFile);
                }
            }
            ++n2;
        }
        return remainedScreenshotFileList.toArray(new File[remainedScreenshotFileList.size()]);
    }

    private static String[] generatePlayerNamePermutations(String playerName) {
        int lsCount = 0;
        int i = playerName.length() - 1;
        while (i >= 0) {
            if (playerName.charAt(i) == 'l') {
                ++lsCount;
            }
            --i;
        }
        if (lsCount == 0) {
            return new String[]{playerName.toLowerCase()};
        }
        if (lsCount > 5) {
            lsCount = 5;
        }
        int[] lsIndices = new int[lsCount];
        int counter = 0;
        int i2 = playerName.length() - 1;
        while (i2 >= 0 && counter < lsCount) {
            if (playerName.charAt(i2) == 'l') {
                lsIndices[counter++] = i2;
            }
            --i2;
        }
        String[] playerNamePermutations = new String[1 << lsCount];
        StringBuilder playerNamePermutationBuilder = new StringBuilder();
        int permutation = playerNamePermutations.length - 1;
        while (permutation >= 0) {
            playerNamePermutationBuilder.setLength(0);
            playerNamePermutationBuilder.append(playerName);
            int bitPos = lsCount - 1;
            int bitMask = playerNamePermutations.length >> 1;
            while (bitPos >= 0) {
                playerNamePermutationBuilder.setCharAt(lsIndices[bitPos], (permutation & bitMask) > 0 ? (char)'i' : 'l');
                --bitPos;
                bitMask >>= 1;
            }
            playerNamePermutations[permutation] = playerNamePermutationBuilder.toString().toLowerCase();
            --permutation;
        }
        return playerNamePermutations;
    }

    private void updateHackerList() {
        if (!this.updateNowButton.isEnabled()) {
            return;
        }
        this.updateNowButton.setEnabled(false);
        this.updateNowButton.setText("Updating...");
        this.settingsPanel.getParent().validate();
        new NormalThread(){

            public void run() {
                BufferedReader input = null;
                PrintWriter output = null;
                try {
                    try {
                        String line;
                        PlayerCheckerTab.this.logMessage("", false);
                        PlayerCheckerTab.this.logMessage("Updating hacker list...");
                        if (HACKER_LIST_DIRECTORY.exists() && HACKER_LIST_DIRECTORY.isFile()) {
                            PlayerCheckerTab.this.logMessage("Error: hacker list cache directory exists and is a file: " + HACKER_LIST_DIRECTORY.getAbsolutePath() + " (You have to delete it first!)");
                            throw new Exception();
                        }
                        if (!HACKER_LIST_DIRECTORY.exists() && !HACKER_LIST_DIRECTORY.mkdirs()) {
                            PlayerCheckerTab.this.logMessage("Error: could not create hacker list cache directory: " + HACKER_LIST_DIRECTORY.getAbsolutePath());
                            throw new Exception();
                        }
                        input = new BufferedReader(new InputStreamReader(new URL("http://94.199.240.39/hackerdb/hackers?op=dhl").openStream()));
                        File tempCacheFile = new File("Hacker list cache", "BWHF_hacker_list_cache.txt.dl");
                        output = new PrintWriter(tempCacheFile);
                        while ((line = input.readLine()) != null) {
                            output.println(line);
                        }
                        output.flush();
                        output.close();
                        if (HACKER_LIST_CACHE_FILE.exists() && !HACKER_LIST_CACHE_FILE.delete()) {
                            PlayerCheckerTab.this.logMessage("Error: could not delete old hacker list cache file: " + HACKER_LIST_CACHE_FILE.getAbsolutePath());
                            throw new Exception();
                        }
                        if (!tempCacheFile.renameTo(HACKER_LIST_CACHE_FILE)) {
                            PlayerCheckerTab.this.logMessage("Error: could not rename '" + tempCacheFile.getAbsolutePath() + "' to '" + HACKER_LIST_CACHE_FILE.getAbsolutePath() + "'");
                            throw new Exception();
                        }
                        PlayerCheckerTab.this.lastUpdateTime = HACKER_LIST_CACHE_FILE.lastModified();
                        PlayerCheckerTab.this.refreshLastUpdatedLabel();
                        PlayerCheckerTab.this.logMessage("Update succeeded.");
                        PlayerCheckerTab.this.updateNowButton.setText(PlayerCheckerTab.UPDATE_NOW_BUTTON_TEXT);
                        PlayerCheckerTab.this.reloadPlayerList(HACKER_LIST_CACHE_FILE, PlayerCheckerTab.this.gatewayBwhfHackerSetMap);
                    }
                    catch (Exception e) {
                        PlayerCheckerTab.this.logMessage("Update failed!");
                        e.printStackTrace();
                        PlayerCheckerTab.this.updateNowButton.setText("Update now (update failed!)");
                        if (output != null) {
                            output.close();
                        }
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException ie) {
                                ie.printStackTrace();
                            }
                        }
                        PlayerCheckerTab.this.updateNowButton.setEnabled(true);
                        PlayerCheckerTab.this.settingsPanel.getParent().validate();
                    }
                }
                finally {
                    if (output != null) {
                        output.close();
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException ie) {
                            ie.printStackTrace();
                        }
                    }
                    PlayerCheckerTab.this.updateNowButton.setEnabled(true);
                    PlayerCheckerTab.this.settingsPanel.getParent().validate();
                }
            }
        }.start();
    }

    private synchronized void reloadPlayerList(File file, Map<Integer, Set<String>> gatewayPlayerSetMap) {
        block18: {
            gatewayPlayerSetMap.clear();
            this.logMessage("", false);
            this.logMessage("Reloading player list from file: '" + file.getAbsolutePath() + "'...");
            BufferedReader input = null;
            int skippedLinesCount = 0;
            int playersCount = 0;
            try {
                try {
                    String line;
                    input = new BufferedReader(new FileReader(file));
                    Integer lastGateway = null;
                    Set<String> playerSet = null;
                    while ((line = input.readLine()) != null) {
                        try {
                            int commaIndex = line.indexOf(44);
                            if (commaIndex == line.length() - 1) {
                                throw new Exception();
                            }
                            Integer gateway = Integer.valueOf(line.substring(0, commaIndex));
                            if (!gateway.equals(lastGateway) && (playerSet = gatewayPlayerSetMap.get(gateway)) == null) {
                                playerSet = new HashSet<String>();
                                gatewayPlayerSetMap.put(gateway, playerSet);
                            }
                            playerSet.add(line.substring(commaIndex + 1).toLowerCase());
                            ++playersCount;
                            lastGateway = gateway;
                        }
                        catch (Exception e) {
                            ++skippedLinesCount;
                        }
                    }
                    if (skippedLinesCount > 0) {
                        this.logMessage("Skipped " + skippedLinesCount + " line" + (skippedLinesCount == 1 ? "." : "s."));
                    }
                    this.logMessage("Successfully reloaded " + playersCount + " player" + (playersCount == 1 ? "" : "s") + " from file: '" + file.getAbsolutePath() + "'");
                }
                catch (Exception e) {
                    this.logMessage("Error: failed to load list from file: " + file.getAbsolutePath());
                    if (input == null) break block18;
                    try {
                        input.close();
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                }
            }
        }
    }

    private void refreshLastUpdatedLabel() {
        long lastUpdated = HACKER_LIST_CACHE_FILE.lastModified();
        this.hackerListLastUpdatedLabel.setText(lastUpdated > 0L ? DATE_FORMAT.format(new Date(lastUpdated)) : "&lt;never&gt;");
    }

    private void startCacheAutoUpdater() {
        new NormalThread(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (PlayerCheckerTab.this.playerCheckerEnabledCheckBox.isSelected() && new Date().getTime() > PlayerCheckerTab.this.lastUpdateTime + 3600000L * (long)((Integer)PlayerCheckerTab.this.hackerListUpdateIntervalComboBox.getSelectedItem()).intValue()) {
                                PlayerCheckerTab.this.lastUpdateTime = new Date().getTime();
                                PlayerCheckerTab.this.updateHackerList();
                            }
                            7.sleep(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("playerCheckerEnabled", Boolean.toString(this.playerCheckerEnabledCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("hackerListUpdateInterval", Integer.toString(this.hackerListUpdateIntervalComboBox.getSelectedIndex()));
        Utils.settingsProperties.setProperty("includeCustomPlayerList", Boolean.toString(this.includeCustomPlayerListCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("customPlayerListFile", this.customPlayerListFileTextField.getText());
        Utils.settingsProperties.setProperty("sayClean", Boolean.toString(this.sayCleanCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("deleteGameLobbyScreenshots", Boolean.toString(this.deleteGameLobbyScreenshotsCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("echoRecognizedPlayerNames", Boolean.toString(this.echoRecognizedPlayerNamesCheckBox.isSelected()));
    }
}

