/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.PlayerCheckerTab;
import hu.belicza.andras.bwhfagent.view.ProgressLoggedTab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashSet;
import javax.imageio.ImageIO;
import swingwt.awt.Component;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTextField;

public class PcxConverterTab
extends ProgressLoggedTab {
    private static final String LOG_FILE_NAME = "pcx_converter.log";
    private static final String PCX_FILE_EXTENSION = ".pcx";
    private static final long TIME_BETWEEN_CHECKS_FOR_NEW_PCX_FILES_MS = 1000L;
    private static final int MIN_RESIZED_WIDTH = 4;
    private static final int MAX_RESIZED_WIDTH = 1920;
    private static final swingwtx.swing.filechooser.FileFilter SWING_PCX_FILE_FILTER = new swingwtx.swing.filechooser.FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(PcxConverterTab.PCX_FILE_EXTENSION);
        }

        public String getDescription() {
            return "PCX image files (*.pcx)";
        }
    };
    private final JCheckBox autoConvertEnabledCheckBox = new JCheckBox("Automatically convert new PCX images detected in Starcraft directory", Boolean.parseBoolean(Utils.settingsProperties.getProperty("autoConvertPcxEnabled")));
    private final JComboBox outputFormatComboBox = new JComboBox((Object[])PcxConverterTab.unifyStrings(ImageIO.getWriterFormatNames()));
    private final JCheckBox resizeConvertedImagesCheckBox = new JCheckBox("Resize converted images,", Boolean.parseBoolean(Utils.settingsProperties.getProperty("resizeConvertedImages")));
    private final JTextField resizedImageWidthTextField = new JTextField(Utils.settingsProperties.getProperty("resizedImageWidth"), 1);
    private final JLabel resizedImageHeightLabel = new JLabel();
    private final JButton selectFilesButton = new JButton("Select PCX files to convert...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final Object lock = new Object();

    public PcxConverterTab() {
        super("PCX converter", (Icon)IconResourceManager.ICON_PCX_CONVERTER, LOG_FILE_NAME);
        this.outputFormatComboBox.setSelectedItem((Object)Utils.settingsProperties.getProperty("pcxOutputFormat"));
        this.buildGUI();
        this.startAutoConverter();
    }

    private static String[] unifyStrings(String[] strings) {
        HashSet<String> unifiedStringSet = new HashSet<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String uppercasedString = string.toUpperCase();
            if (!uppercasedString.equals("WBMP")) {
                unifiedStringSet.add(uppercasedString.equals("JPEG") ? "JPG" : uppercasedString);
            }
            ++n2;
        }
        return unifiedStringSet.toArray(new String[unifiedStringSet.size()]);
    }

    protected void buildGUI() {
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.autoConvertEnabledCheckBox));
        JPanel panel = Utils.createWrapperPanel();
        panel.add((Component)new JLabel("Output image format:"));
        panel.add((Component)this.outputFormatComboBox);
        this.contentBox.add((Component)panel);
        panel = Utils.createWrapperPanel();
        this.resizeConvertedImagesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PcxConverterTab.this.resizedImageWidthTextField.setEnabled(PcxConverterTab.this.resizeConvertedImagesCheckBox.isSelected());
            }
        });
        this.resizeConvertedImagesCheckBox.doClick();
        panel.add((Component)this.resizeConvertedImagesCheckBox);
        panel.add((Component)new JLabel("resized image width (4..1920):"));
        this.resizedImageWidthTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                PcxConverterTab.this.syncResizedImageHeightLabel();
            }

            public void keyReleased(KeyEvent event) {
                PcxConverterTab.this.syncResizedImageHeightLabel();
            }

            public void keyTyped(KeyEvent event) {
                PcxConverterTab.this.syncResizedImageHeightLabel();
            }
        });
        panel.add((Component)this.resizedImageWidthTextField);
        panel.add((Component)new JLabel(" pixels, height: "));
        panel.add((Component)this.resizedImageHeightLabel);
        panel.add((Component)new JLabel(" pixels."));
        this.syncResizedImageHeightLabel();
        this.contentBox.add((Component)panel);
        this.selectFilesButton.setMnemonic('f');
        this.selectFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(new File(MainFrame.getInstance().generalSettingsTab.starcraftFolderTextField.getText()));
                fileChooser.setExtensionFilters(new String[]{"*.pcx", "*.*"}, new String[]{"PCX image files (*.pcx)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(SWING_PCX_FILE_FILTER);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog((Component)PcxConverterTab.this.getContent()) == 0) {
                    PcxConverterTab.this.convertPcxFiles(fileChooser.getSelectedFiles(), false, true);
                }
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.selectFilesButton));
        super.buildGUI();
    }

    private void syncResizedImageHeightLabel() {
        Integer width = this.getSuppliedWidth();
        if (width == null) {
            this.resizedImageHeightLabel.setText("N/A");
        } else {
            this.resizedImageHeightLabel.setText(Integer.toString(width * 3 / 4));
        }
    }

    private Integer getSuppliedWidth() {
        int width;
        block3: {
            try {
                width = Integer.parseInt(this.resizedImageWidthTextField.getText());
                if (width >= 4 && width <= 1920) break block3;
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return width;
    }

    private void convertPcxFiles(final File[] pcxFiles, final boolean deleteOnSuccess, final boolean printNewLinesAtStart) {
        this.selectFilesButton.setEnabled(false);
        new NormalThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = PcxConverterTab.this.lock;
                    synchronized (object) {
                        PcxConverterTab.this.progressBar.setValue(0);
                        PcxConverterTab.this.progressBar.setMaximum(pcxFiles.length);
                        if (printNewLinesAtStart) {
                            PcxConverterTab.this.logMessage("\n", false);
                        }
                        String convertingMessage = "Converting " + pcxFiles.length + " pcx file" + (pcxFiles.length == 1 ? "" : "s");
                        PcxConverterTab.this.logMessage(String.valueOf(convertingMessage) + "...");
                        long startTimeNanons = System.nanoTime();
                        String formatName = (String)PcxConverterTab.this.outputFormatComboBox.getSelectedItem();
                        String extension = "." + formatName.toLowerCase();
                        int counter = 0;
                        File[] fileArray = pcxFiles;
                        int n = pcxFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File pcxFile = fileArray[n2];
                            if (pcxFile.isFile()) {
                                String absolutePcxPath = pcxFile.getAbsolutePath();
                                try {
                                    boolean resize;
                                    int extensionIndex = absolutePcxPath.lastIndexOf(46);
                                    BufferedImage image = ImageIO.read(pcxFile);
                                    if (image == null) {
                                        throw new Exception("Failed parsing PCX file: " + absolutePcxPath);
                                    }
                                    boolean bl = resize = PcxConverterTab.this.resizeConvertedImagesCheckBox.isSelected() && PcxConverterTab.this.getSuppliedWidth() != null;
                                    if (resize) {
                                        int width = PcxConverterTab.this.getSuppliedWidth();
                                        int height = width * 3 / 4;
                                        BufferedImage resizedImage = new BufferedImage(width, height, 1);
                                        Graphics2D graphics2D = resizedImage.createGraphics();
                                        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                        graphics2D.drawImage(image, 0, 0, width, height, null);
                                        graphics2D.dispose();
                                        image.flush();
                                        image = resizedImage;
                                    }
                                    ImageIO.write((RenderedImage)image, formatName, new File(String.valueOf(extensionIndex < 0 ? absolutePcxPath : absolutePcxPath.substring(0, extensionIndex)) + extension));
                                    image.flush();
                                    PcxConverterTab.this.logMessage("'" + absolutePcxPath + "' converted " + (resize ? "and resized " : "") + "successfully.");
                                    if (deleteOnSuccess) {
                                        pcxFile.delete();
                                    }
                                }
                                catch (Exception e) {
                                    PcxConverterTab.this.logMessage("Failed to convert '" + absolutePcxPath + "'!");
                                }
                            }
                            PcxConverterTab.this.progressBar.setValue(++counter);
                            ++n2;
                        }
                        long endTimeNanons = System.nanoTime();
                        PcxConverterTab.this.logMessage(String.valueOf(convertingMessage) + " done in " + Utils.formatNanoTimeAmount(endTimeNanons - startTimeNanons));
                    }
                }
                finally {
                    PcxConverterTab.this.selectFilesButton.setEnabled(true);
                }
            }
        }.start();
    }

    private void startAutoConverter() {
        new NormalThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JTextField starcraftFolderTextField = MainFrame.getInstance().generalSettingsTab.starcraftFolderTextField;
                PlayerCheckerTab playerCheckerTab = MainFrame.getInstance().playerCheckerTab;
                final Date[] lastCheckTimeHolder = new Date[1];
                while (true) {
                    try {
                        while (true) {
                            Object object = PcxConverterTab.this.lock;
                            synchronized (object) {
                                if (PcxConverterTab.this.autoConvertEnabledCheckBox.isSelected() || playerCheckerTab.playerCheckerEnabledCheckBox.isSelected()) {
                                    if (lastCheckTimeHolder[0] == null) {
                                        lastCheckTimeHolder[0] = new Date();
                                    }
                                    File[] pcxFiles = new File(starcraftFolderTextField.getText()).listFiles(new FileFilter(){

                                        public boolean accept(File pathname) {
                                            return pathname.lastModified() > lastCheckTimeHolder[0].getTime() && pathname.getName().toLowerCase().endsWith(PcxConverterTab.PCX_FILE_EXTENSION);
                                        }
                                    });
                                    lastCheckTimeHolder[0] = new Date();
                                    if (pcxFiles != null && pcxFiles.length > 0) {
                                        if (playerCheckerTab.playerCheckerEnabledCheckBox.isSelected()) {
                                            pcxFiles = playerCheckerTab.checkPlayers(pcxFiles);
                                        }
                                        if (PcxConverterTab.this.autoConvertEnabledCheckBox.isSelected() && pcxFiles.length > 0) {
                                            PcxConverterTab.this.logMessage("\n", false);
                                            PcxConverterTab.this.logMessage("New PCX file" + (pcxFiles.length == 1 ? "" : "s") + " detected - proceeding to convert...");
                                            PcxConverterTab.this.convertPcxFiles(pcxFiles, true, false);
                                        }
                                    }
                                } else {
                                    lastCheckTimeHolder[0] = null;
                                }
                            }
                            6.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("autoConvertPcxEnabled", Boolean.toString(this.autoConvertEnabledCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("pcxOutputFormat", (String)this.outputFormatComboBox.getSelectedItem());
        Utils.settingsProperties.setProperty("resizeConvertedImages", Boolean.toString(this.resizeConvertedImagesCheckBox.isSelected()));
        Utils.settingsProperties.setProperty("resizedImageWidth", this.resizedImageWidthTextField.getText());
    }
}

