/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhfagent.Consts;
import hu.belicza.andras.bwhfagent.view.AboutTab;
import hu.belicza.andras.bwhfagent.view.AutoscanTab;
import hu.belicza.andras.bwhfagent.view.ChartsTab;
import hu.belicza.andras.bwhfagent.view.GameChatTab;
import hu.belicza.andras.bwhfagent.view.GeneralSettingsTab;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.ManualScanTab;
import hu.belicza.andras.bwhfagent.view.PcxConverterTab;
import hu.belicza.andras.bwhfagent.view.PlayerCheckerTab;
import hu.belicza.andras.bwhfagent.view.PlayerMatcherTab;
import hu.belicza.andras.bwhfagent.view.PlayersNetworkTab;
import hu.belicza.andras.bwhfagent.view.ReplaySearchTab;
import hu.belicza.andras.bwhfagent.view.Tab;
import hu.belicza.andras.bwhfagent.view.Utils;
import hu.belicza.andras.hackerdb.ServerApiConsts;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.LayoutManager2;
import swingwt.awt.Toolkit;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.WindowAdapter;
import swingwt.awt.event.WindowEvent;
import swingwt.awt.event.WindowListener;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFrame;
import swingwtx.swing.JLabel;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTabbedPane;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class MainFrame
extends JFrame {
    private static MainFrame mainFrame;
    public final String applicationVersion;
    protected final JButton startScButton = new JButton("Start/Switch to Starcraft", (Icon)IconResourceManager.ICON_WRAITH);
    protected final JButton minimizeToTrayButton = new JButton("Minimize to tray", (Icon)IconResourceManager.ICON_MINIMIZE);
    protected final JLabel starcraftFolderStatusLabel = new JLabel();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    protected final AutoscanTab autoscanTab;
    protected final ManualScanTab manualScanTab;
    protected final PlayerCheckerTab playerCheckerTab;
    protected final ChartsTab chartsTab;
    protected final ReplaySearchTab replaySearchTab;
    protected final GameChatTab gameChatTab;
    protected final PlayersNetworkTab playersNetworkTab;
    protected final PlayerMatcherTab playerMatcherTab;
    protected final GeneralSettingsTab generalSettingsTab;
    private final Tab[] tabs;
    private TrayIcon trayIcon;
    private MenuItem restoreMainWindowMenuItem;
    private MenuItem hideMainWindowMenuItem;
    private MenuItem disableTrayIconMenuItem;
    private boolean trayIconInstalled;
    private boolean windowHasBeenShown;
    private boolean inWonderland = false;

    public static MainFrame getInstance() {
        return mainFrame;
    }

    public MainFrame(String applicationVersion, String[] arguments) {
        if (mainFrame != null) {
            throw new RuntimeException("Only one main frame is allowed per Java Virtual Machine!");
        }
        mainFrame = this;
        this.applicationVersion = applicationVersion;
        this.setTitle("BWHF Agent");
        this.setIconImage((this.inWonderland ? IconResourceManager.ICON_BLUE_PILL : IconResourceManager.ICON_RED_PILL).getImage());
        this.generalSettingsTab = new GeneralSettingsTab();
        this.autoscanTab = new AutoscanTab();
        this.manualScanTab = new ManualScanTab();
        this.playerCheckerTab = new PlayerCheckerTab();
        this.chartsTab = new ChartsTab();
        this.replaySearchTab = new ReplaySearchTab();
        this.gameChatTab = new GameChatTab();
        this.playersNetworkTab = new PlayersNetworkTab();
        this.playerMatcherTab = new PlayerMatcherTab();
        this.tabs = new Tab[]{this.autoscanTab, this.manualScanTab, this.playerCheckerTab, this.chartsTab, this.replaySearchTab, this.gameChatTab, new PcxConverterTab(), this.playersNetworkTab, this.playerMatcherTab, this.generalSettingsTab, new AboutTab()};
        this.buildGUI();
        this.setDefaultCloseOperation(0);
        this.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                MainFrame.this.closeAgent();
            }

            public void windowIconified(WindowEvent event) {
                if (MainFrame.this.trayIconInstalled && MainFrame.this.generalSettingsTab.alwaysMinimizeToTrayCheckBox.isSelected()) {
                    MainFrame.this.setVisible(false);
                }
            }
        });
        if (this.generalSettingsTab.enableSystemTrayIconCheckBox.isSelected()) {
            this.installSystemTrayIcon();
        }
        File argumentFile = null;
        if (arguments.length > 0) {
            argumentFile = new File(arguments[0]);
        }
        if (argumentFile.isFile()) {
            this.setVisible(true);
            this.selectTab(this.chartsTab);
            this.chartsTab.setReplayFile(new File(arguments[0]));
        } else {
            this.setVisible(!this.trayIconInstalled || !this.generalSettingsTab.startAgentMinimizedToTrayCheckBox.isSelected());
        }
        if (!new File("settings.properties").exists()) {
            JOptionPane.showMessageDialog(null, (Object)"Welcome!\nThis is the first run of BWHF Agent.\n\nPlease set the Starcraft directory in the General settings tab.\nDon't forget to re-enter your Key if you have one.\n\nOptionally you can copy the 'settings.properties' file from your old BWHF Agent's folder to keep the old settings.\n\nThank your for choosing BWHF Agent.", (String)"Welcome", (int)2);
        }
    }

    private void buildGUI() {
        JPanel northBox = new JPanel((LayoutManager2)new BorderLayout());
        JPanel panel = new JPanel((LayoutManager2)new BorderLayout());
        JPanel startStarcraftPanel = Utils.createWrapperPanel();
        this.startScButton.setMnemonic(this.startScButton.getText().charAt(0));
        this.startScButton.addActionListener(new ActionListener(){

            public void actionPerformed(swingwt.awt.event.ActionEvent event) {
                MainFrame.this.startOrSwitchToStarcraft();
            }
        });
        startStarcraftPanel.add((Component)this.startScButton);
        startStarcraftPanel.add((Component)this.starcraftFolderStatusLabel);
        panel.add((Component)startStarcraftPanel, (Object)"Center");
        this.minimizeToTrayButton.addActionListener(new ActionListener(){

            public void actionPerformed(swingwt.awt.event.ActionEvent event) {
                MainFrame.this.setVisible(false);
            }
        });
        panel.add((Component)Utils.wrapInPanel((JComponent)this.minimizeToTrayButton), (Object)"East");
        northBox.add((Component)panel, (Object)"Center");
        this.getContentPane().add((Component)northBox, (Object)"North");
        int tabIndex = 0;
        while (tabIndex < this.tabs.length) {
            Tab tab = this.tabs[tabIndex];
            this.tabbedPane.add(tab.getTitle(), (Component)tab.getContent());
            if (tab.getIcon() != null) {
                this.tabbedPane.setIconAt(tabIndex, tab.getIcon());
            }
            ++tabIndex;
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                MainFrame.this.tabs[MainFrame.this.tabbedPane.getSelectedIndex()].onSelected();
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, (Object)"Center");
        if (SystemTray.isSupported()) {
            this.trayIcon = new TrayIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource(this.inWonderland ? "blue-pill.gif" : "red-pill.gif")).getImage());
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.setToolTip("BWHF Agent is running.");
            this.trayIcon.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.setVisible(true);
                }
            });
            PopupMenu popupMenu = new PopupMenu();
            MenuItem startStarcraftMenuItem = new MenuItem("Start / Switch to Starcraft");
            startStarcraftMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.startOrSwitchToStarcraft();
                }
            });
            popupMenu.add(startStarcraftMenuItem);
            final PopupMenu gatewayChangerPopupMenu = new PopupMenu("Change gateway");
            final Runnable setGatewayMenuItemStatesTask = new Runnable(){

                public void run() {
                    String selectedGateway = (String)MainFrame.this.autoscanTab.gatewayComboBox.getSelectedItem();
                    int i = gatewayChangerPopupMenu.getItemCount() - 1;
                    while (i >= 0) {
                        CheckboxMenuItem gatewayMenuItem = (CheckboxMenuItem)gatewayChangerPopupMenu.getItem(i);
                        gatewayMenuItem.setState(gatewayMenuItem.getLabel().equals(selectedGateway));
                        --i;
                    }
                }
            };
            String[] stringArray = ServerApiConsts.GATEWAYS;
            int n = ServerApiConsts.GATEWAYS.length;
            int n2 = 0;
            while (n2 < n) {
                final String gateway = stringArray[n2];
                CheckboxMenuItem gatewayMenuItem = new CheckboxMenuItem(gateway);
                gatewayMenuItem.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent event) {
                        MainFrame.this.autoscanTab.gatewayComboBox.setSelectedItem((Object)gateway);
                        setGatewayMenuItemStatesTask.run();
                    }
                });
                gatewayChangerPopupMenu.add(gatewayMenuItem);
                ++n2;
            }
            setGatewayMenuItemStatesTask.run();
            this.autoscanTab.gatewayComboBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    setGatewayMenuItemStatesTask.run();
                }
            });
            popupMenu.add(gatewayChangerPopupMenu);
            PopupMenu lastReplayPopupMenu = new PopupMenu("LastReplay");
            MenuItem showOnChartsMenuItem = new MenuItem("Show on charts");
            showOnChartsMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.setVisible(true);
                    MainFrame.this.selectTab(MainFrame.this.chartsTab);
                    MainFrame.this.chartsTab.setReplayFile(new File(MainFrame.this.generalSettingsTab.starcraftFolderTextField.getText(), "maps/replays/LastReplay.rep"));
                }
            });
            lastReplayPopupMenu.add(showOnChartsMenuItem);
            MenuItem displayGameChatMenuItem = new MenuItem("Display game chat");
            displayGameChatMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.setVisible(true);
                    MainFrame.this.selectTab(MainFrame.this.gameChatTab);
                    if (MainFrame.this.gameChatTab.displayFromLastReplayButton.isEnabled()) {
                        MainFrame.this.gameChatTab.displayFromLastReplayButton.doClick();
                    }
                }
            });
            lastReplayPopupMenu.add(displayGameChatMenuItem);
            MenuItem scanMenuItem = new MenuItem("Scan for hacks");
            scanMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.setVisible(true);
                    MainFrame.this.selectTab(MainFrame.this.manualScanTab);
                    if (MainFrame.this.manualScanTab.scanLastReplayButton.isEnabled()) {
                        MainFrame.this.manualScanTab.scanLastReplayButton.doClick();
                    }
                }
            });
            lastReplayPopupMenu.add(scanMenuItem);
            popupMenu.add(lastReplayPopupMenu);
            popupMenu.addSeparator();
            this.restoreMainWindowMenuItem = new MenuItem("Restore main window");
            this.restoreMainWindowMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.setVisible(true);
                }
            });
            popupMenu.add(this.restoreMainWindowMenuItem);
            this.hideMainWindowMenuItem = new MenuItem("Hide main window");
            this.hideMainWindowMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.setVisible(false);
                }
            });
            popupMenu.add(this.hideMainWindowMenuItem);
            popupMenu.addSeparator();
            this.disableTrayIconMenuItem = new MenuItem("Disable tray icon");
            this.disableTrayIconMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.generalSettingsTab.enableSystemTrayIconCheckBox.setSelected(false);
                    MainFrame.this.generalSettingsTab.enableSystemTrayIconCheckBox.doClick();
                }
            });
            popupMenu.add(this.disableTrayIconMenuItem);
            MenuItem closeMenuItem = new MenuItem("Close BWHF Agent");
            closeMenuItem.addActionListener(new java.awt.event.ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MainFrame.this.closeAgent();
                }
            });
            popupMenu.add(closeMenuItem);
            this.trayIcon.setPopupMenu(popupMenu);
        }
    }

    public void setVisible(boolean visible) {
        if (this.restoreMainWindowMenuItem != null) {
            this.restoreMainWindowMenuItem.setEnabled(!visible);
        }
        if (this.hideMainWindowMenuItem != null) {
            this.hideMainWindowMenuItem.setEnabled(visible);
        }
        if (this.disableTrayIconMenuItem != null) {
            this.disableTrayIconMenuItem.setEnabled(visible);
        }
        boolean windowMaximized = false;
        if (visible && !this.windowHasBeenShown) {
            StringTokenizer boundsTokenizer = new StringTokenizer(this.generalSettingsTab.saveWindowPositionCheckBox.isSelected() ? Utils.settingsProperties.getProperty("windowPosition") : Consts.DEFAULT_SETTINGS_PROPERTIES.getProperty("windowPosition"), ",");
            boolean bl = windowMaximized = boundsTokenizer.countTokens() != 4;
            if (!windowMaximized) {
                int x = Integer.parseInt(boundsTokenizer.nextToken());
                int y = Integer.parseInt(boundsTokenizer.nextToken());
                int width = Integer.parseInt(boundsTokenizer.nextToken());
                int height = Integer.parseInt(boundsTokenizer.nextToken());
                this.setBounds(x, y, width, height);
            }
        }
        super.setVisible(visible);
        if (visible) {
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            if (!this.windowHasBeenShown) {
                if (windowMaximized) {
                    this.setExtendedState(6);
                }
                Tab[] tabArray = this.tabs;
                int n = this.tabs.length;
                int n2 = 0;
                while (n2 < n) {
                    Tab tab = tabArray[n2];
                    tab.initializationEnded();
                    ++n2;
                }
                this.windowHasBeenShown = true;
            }
            this.toFront();
        }
    }

    private void closeAgent() {
        Tab[] tabArray = this.tabs;
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            tab.assignUsedProperties();
            ++n2;
        }
        Utils.saveSettingsProperties();
        System.exit(0);
    }

    private void startOrSwitchToStarcraft() {
        try {
            Runtime.getRuntime().exec(new File(this.generalSettingsTab.starcraftFolderTextField.getText(), "StarCraft.exe").getCanonicalPath(), null, new File(this.generalSettingsTab.starcraftFolderTextField.getText()));
        }
        catch (IOException ie) {
            final JFrame errorFrame = new JFrame("BWHF Agent error");
            errorFrame.setIconImage((this.inWonderland ? IconResourceManager.ICON_BLUE_PILL : IconResourceManager.ICON_RED_PILL).getImage());
            errorFrame.getContentPane().add((Component)Utils.wrapInPanel((JComponent)new JLabel("Could not start StarCraft.exe!")), (Object)"North");
            errorFrame.getContentPane().add((Component)Utils.wrapInPanel((JComponent)new JLabel("Is Starcraft directory properly set?")), (Object)"Center");
            JButton closeButton = new JButton("Close");
            closeButton.setMnemonic(closeButton.getText().charAt(0));
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(swingwt.awt.event.ActionEvent event) {
                    errorFrame.dispose();
                }
            });
            errorFrame.add((Component)Utils.wrapInPanel((JComponent)closeButton), (Object)"South");
            errorFrame.setResizable(false);
            errorFrame.setDefaultCloseOperation(2);
            errorFrame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            errorFrame.setLocation((screenSize.width - 220) / 2, (screenSize.height - 120) / 2);
            errorFrame.setVisible(true);
            closeButton.requestFocusInWindow();
        }
    }

    public void selectTab(Tab tab) {
        this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfComponent((Component)tab.getContent()));
    }

    public void installSystemTrayIcon() {
        SystemTray systemTray;
        if (this.trayIcon != null && (systemTray = SystemTray.getSystemTray()).getTrayIcons().length == 0) {
            try {
                systemTray.add(this.trayIcon);
                this.trayIconInstalled = true;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    public void removeSystemTrayIcon() {
        if (this.trayIcon != null) {
            SystemTray.getSystemTray().remove(this.trayIcon);
            this.trayIconInstalled = false;
        }
    }

    public void stayInWonderland() {
        this.inWonderland = true;
        this.setIconImage(IconResourceManager.ICON_BLUE_PILL.getImage());
        if (this.trayIcon != null) {
            this.trayIcon.setImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("blue-pill.gif")).getImage());
        }
    }
}

