/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhfagent.view;

import hu.belicza.andras.bwhf.control.BinRepParser;
import hu.belicza.andras.bwhf.model.Replay;
import hu.belicza.andras.bwhfagent.view.IconResourceManager;
import hu.belicza.andras.bwhfagent.view.MainFrame;
import hu.belicza.andras.bwhfagent.view.NormalThread;
import hu.belicza.andras.bwhfagent.view.ProgressLoggedTab;
import hu.belicza.andras.bwhfagent.view.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import swingwt.awt.Component;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JFileChooser;
import swingwtx.swing.JPanel;

public class GameChatTab
extends ProgressLoggedTab {
    private static final String LOG_FILE_NAME = "game_chat.log";
    protected final JButton displayFromLastReplayButton = new JButton("Display game chat from 'LastReplay.rep'", (Icon)IconResourceManager.ICON_LASTREPLAY);
    private final JButton selectFileToDisplayFromButton = new JButton("Select file to display game chat from...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final JButton selectFilesToExtractFromButton = new JButton("Select files to extract game chat from...", (Icon)IconResourceManager.ICON_FILE_CHOOSER);
    private final JCheckBox includeReplayHeaderCheckBox = new JCheckBox("Also include replay header information", Boolean.parseBoolean(Utils.settingsProperties.getProperty("includeReplayHeader")));

    public GameChatTab() {
        super("Game chat", (Icon)IconResourceManager.ICON_GAME_CHATS, LOG_FILE_NAME);
        this.buildGUI();
    }

    protected void buildGUI() {
        JPanel panel = Utils.createWrapperPanel();
        this.displayFromLastReplayButton.setMnemonic('l');
        this.displayFromLastReplayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GameChatTab.this.showGameChatFromReplay(new File(MainFrame.getInstance().generalSettingsTab.starcraftFolderTextField.getText(), "maps/replays/LastReplay.rep"));
            }
        });
        panel.add((Component)this.displayFromLastReplayButton);
        this.selectFileToDisplayFromButton.setMnemonic('d');
        this.selectFileToDisplayFromButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(MainFrame.getInstance().generalSettingsTab.getReplayStartFolder());
                fileChooser.setExtensionFilters(new String[]{"*.rep", "*.*"}, new String[]{"Replay Files (*.rep)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(Utils.SWING_REPLAY_FILE_FILTER);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setMultiSelectionEnabled(false);
                if (fileChooser.showOpenDialog((Component)GameChatTab.this.getContent()) == 0) {
                    GameChatTab.this.showGameChatFromReplay(fileChooser.getSelectedFile());
                }
            }
        });
        panel.add((Component)this.selectFileToDisplayFromButton);
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)panel));
        this.selectFilesToExtractFromButton.setMnemonic('f');
        this.selectFilesToExtractFromButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(MainFrame.getInstance().generalSettingsTab.getReplayStartFolder());
                fileChooser.setExtensionFilters(new String[]{"*.rep", "*.*"}, new String[]{"Replay Files (*.rep)", "All files (*.*)"});
                fileChooser.addChoosableFileFilter(Utils.SWING_REPLAY_FILE_FILTER);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog((Component)GameChatTab.this.getContent()) == 0) {
                    GameChatTab.this.extractGameChatFromFiles(fileChooser.getSelectedFiles());
                }
            }
        });
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.selectFilesToExtractFromButton));
        this.contentBox.add((Component)Utils.wrapInPanel((JComponent)this.includeReplayHeaderCheckBox));
        super.buildGUI();
    }

    public void showGameChatFromReplay(File replayFile) {
        if (!this.selectFileToDisplayFromButton.isEnabled()) {
            return;
        }
        this.selectFilesToExtractFromButton.setEnabled(false);
        this.selectFileToDisplayFromButton.setEnabled(false);
        this.displayFromLastReplayButton.setEnabled(false);
        try {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(1);
            Replay replay = BinRepParser.parseReplay(replayFile, true, true);
            this.logMessage("\n", false);
            if (replay == null) {
                this.logMessage("Could not extract game chat from 'maps/replays/LastReplay.rep'!");
            } else {
                if (this.includeReplayHeaderCheckBox.isSelected()) {
                    this.logMessage("Replay header information of 'maps/replays/LastReplay.rep':");
                    StringWriter headerInfoWriter = new StringWriter();
                    replay.replayHeader.printHeaderInformation(new PrintWriter(headerInfoWriter));
                    this.logMessage(headerInfoWriter.toString(), false);
                    this.logMessage("", false);
                }
                this.logMessage("Game chat of 'maps/replays/LastReplay.rep':");
                this.logMessage(replay.gameChat, false);
                this.logMessage("End of game chat of 'maps/replays/LastReplay.rep'.");
            }
            this.progressBar.setValue(1);
        }
        finally {
            this.selectFilesToExtractFromButton.setEnabled(true);
            this.selectFileToDisplayFromButton.setEnabled(true);
            this.displayFromLastReplayButton.setEnabled(true);
        }
    }

    public void extractGameChatFromFiles(final File[] replayFiles) {
        if (!this.selectFilesToExtractFromButton.isEnabled()) {
            return;
        }
        this.selectFilesToExtractFromButton.setEnabled(false);
        this.selectFileToDisplayFromButton.setEnabled(false);
        this.displayFromLastReplayButton.setEnabled(false);
        new NormalThread(){

            public void run() {
                try {
                    GameChatTab.this.progressBar.setValue(0);
                    GameChatTab.this.progressBar.setMaximum(replayFiles.length);
                    GameChatTab.this.logMessage("\n", false);
                    String extractingMessage = "Extracting game chat from " + replayFiles.length + " replay" + (replayFiles.length == 1 ? "" : "s");
                    GameChatTab.this.logMessage(String.valueOf(extractingMessage) + "...");
                    GameChatTab.this.logMessage("Game chats will be written to text files named after the replays.");
                    long startTimeNanons = System.nanoTime();
                    int counter = 0;
                    File[] fileArray = replayFiles;
                    int n = replayFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block15: {
                            File replayFile = fileArray[n2];
                            String absoluteReplayPath = replayFile.getAbsolutePath();
                            Replay replay = BinRepParser.parseReplay(replayFile, true, true);
                            if (replay == null) {
                                GameChatTab.this.logMessage("Could not extract game chat from '" + absoluteReplayPath + "'!");
                            } else {
                                int extensionIndex = absoluteReplayPath.lastIndexOf(46);
                                String gameChatFileName = String.valueOf(extensionIndex < 0 ? absoluteReplayPath : absoluteReplayPath.substring(0, extensionIndex)) + ".txt";
                                PrintWriter output = null;
                                try {
                                    try {
                                        output = new PrintWriter(new FileWriter(gameChatFileName));
                                        if (GameChatTab.this.includeReplayHeaderCheckBox.isSelected()) {
                                            output.println("Replay header information of '" + absoluteReplayPath + "':");
                                            replay.replayHeader.printHeaderInformation(output);
                                            output.println();
                                        }
                                        output.println("Game chat of '" + absoluteReplayPath + "':");
                                        output.println(replay.gameChat);
                                        output.flush();
                                        GameChatTab.this.logMessage("Game chat from '" + absoluteReplayPath + "' successfully extracted.");
                                    }
                                    catch (Exception e) {
                                        GameChatTab.this.logMessage("Could not write game chat to '" + gameChatFileName + "'!");
                                        if (output != null) {
                                            output.close();
                                        }
                                        break block15;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (output != null) {
                                        output.close();
                                    }
                                    throw throwable;
                                }
                                if (output != null) {
                                    output.close();
                                }
                            }
                        }
                        GameChatTab.this.progressBar.setValue(++counter);
                        ++n2;
                    }
                    long endTimeNanons = System.nanoTime();
                    GameChatTab.this.logMessage(String.valueOf(extractingMessage) + " done in " + Utils.formatNanoTimeAmount(endTimeNanons - startTimeNanons));
                }
                finally {
                    GameChatTab.this.selectFilesToExtractFromButton.setEnabled(true);
                    GameChatTab.this.selectFileToDisplayFromButton.setEnabled(true);
                    GameChatTab.this.displayFromLastReplayButton.setEnabled(true);
                }
            }
        }.start();
    }

    public void assignUsedProperties() {
        Utils.settingsProperties.setProperty("includeReplayHeader", Boolean.toString(this.includeReplayHeaderCheckBox.isSelected()));
    }
}

