/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.bwhf.model;

import hu.belicza.andras.bwhf.model.ReplayHeader;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action
implements Comparable<Action> {
    public static final byte ACTION_NAME_INDEX_UNKNOWN = -1;
    public static final byte ACTION_NAME_INDEX_BWCHART_HACK = -2;
    public static final byte ACTION_NAME_INDEX_ATTACK_MOVE = -3;
    public static final byte ACTION_NAME_INDEX_GATHER = -4;
    public static final byte ACTION_NAME_INDEX_SET_RALLY = -5;
    public static final byte ACTION_NAME_INDEX_CANCEL_TRAIN = 32;
    public static final byte ACTION_NAME_INDEX_0X33 = 51;
    public static final byte ACTION_NAME_INDEX_HATCH = 35;
    public static final byte ACTION_NAME_INDEX_TRAIN = 31;
    public static final byte ACTION_NAME_INDEX_HOTKEY = 19;
    public static final byte ACTION_NAME_INDEX_USE_CHEAT = 18;
    public static final byte ACTION_NAME_INDEX_SELECT = 9;
    public static final byte ACTION_NAME_INDEX_SHIFT_SELECT = 10;
    public static final byte ACTION_NAME_INDEX_MOVE = 20;
    public static final byte ACTION_NAME_INDEX_BUILD = 12;
    public static final byte ACTION_NAME_INDEX_ALLY = 14;
    public static final byte ACTION_NAME_INDEX_VISION = 13;
    public static final byte ACTION_NAME_INDEX_UNLOAD_ALL = 40;
    public static final byte ACTION_NAME_INDEX_UNLOAD = 41;
    public static final byte ACTION_NAME_INDEX_MORPH = 53;
    public static final byte ACTION_NAME_INDEX_LEAVE = 87;
    public static final byte ACTION_NAME_INDEX_BUILD_SUBUNIT = 39;
    public static final byte[] ACTION_IDS = new byte[]{-2, 32, 51, 35, 31, 19, 18, 9, 20, -3, -4, 12, 14, 13};
    public static final Map<Byte, String> ACTION_ID_NAME_MAP = new HashMap<Byte, String>();
    public static final byte SUBACTION_NAME_INDEX_UNKNOWN = -1;
    public static final byte SUBACTION_NAME_INDEX_UNLOAD = 112;
    public static final byte SUBACTION_NAME_INDEX_LAUNCH_NUKE = 126;
    public static final byte SUBACTION_NAME_INDEX_RECALL = -113;
    public static final Map<Byte, String> SUBACTION_ID_NAME_MAP;
    public static final Map<Byte, String> RESEARCH_ID_NAME_MAP;
    public static final Map<Byte, String> UPGRADE_ID_NAME_MAP;
    public static final short UNIT_NAME_INDEX_UNKNOWN = -1;
    public static final short UNIT_NAME_INDEX_SCV = 7;
    public static final short UNIT_NAME_INDEX_DRONE = 41;
    public static final short UNIT_NAME_INDEX_PROBE = 64;
    public static final short[] UNIT_IDS;
    public static final short BUILDING_NAME_INDEX_NON_BUILDING = -1;
    public static final short BUILDING_NAME_INDEX_COMSAT = 107;
    public static final short BUILDING_NAME_INDEX_CONTROL_TOWER = 115;
    public static final short BUILDING_NAME_INDEX_NEXUS = 154;
    public static final short BUILDING_NAME_INDEX_COMMAND_CENTER = 106;
    public static final short BUILDING_NAME_INDEX_HATCHERY = 131;
    public static final short BUILDING_NAME_INDEX_BUNKER = 125;
    public static final short BUILDING_NAME_INDEX_PHOTON_CANNON = 162;
    public static final short BUILDING_NAME_INDEX_SUNKEN_COLONY = 146;
    public static final short BUILDING_NAME_INDEX_NYDUS_CANAL = 134;
    public static final short BUILDING_NAME_INDEX_FIRST_ZERG_BUILDING = 131;
    public static final short BUILDING_NAME_INDEX_LAST_ZERG_BUILDING = 149;
    public static final Map<Short, String> UNIT_ID_NAME_MAP;
    public static final Map<Short, Size> BUILDING_ID_SIZE_MAP;
    public static final Map<Byte, String> GAME_SPEED_MAP;
    public static final String HOTKEY_ACTION_PARAM_NAME_SELECT = "Select";
    public static final String HOTKEY_ACTION_PARAM_NAME_ADD = "Add";
    public static final String HOTKEY_ACTION_PARAM_NAME_ASSIGN = "Assign";
    public final int iteration;
    public String name;
    public final String parameters;
    public final String unitIds;
    public final byte actionNameIndex;
    public final byte subactionNameIndex;
    public final short parameterUnitNameIndex;
    public final short parameterBuildingNameIndex;
    private String toStringValue;
    private String toStringValueSeconds;

    static {
        ACTION_ID_NAME_MAP.put((byte)9, HOTKEY_ACTION_PARAM_NAME_SELECT);
        ACTION_ID_NAME_MAP.put((byte)10, "Shift Select");
        ACTION_ID_NAME_MAP.put((byte)11, "Shift Deselect");
        ACTION_ID_NAME_MAP.put((byte)12, "Build");
        ACTION_ID_NAME_MAP.put((byte)13, "Vision");
        ACTION_ID_NAME_MAP.put((byte)14, "Ally");
        ACTION_ID_NAME_MAP.put((byte)15, "Change Game Speed");
        ACTION_ID_NAME_MAP.put((byte)18, "Use Cheat");
        ACTION_ID_NAME_MAP.put((byte)19, "Hotkey");
        ACTION_ID_NAME_MAP.put((byte)20, "Move");
        ACTION_ID_NAME_MAP.put((byte)24, "Cancel");
        ACTION_ID_NAME_MAP.put((byte)25, "Cancel Hatch");
        ACTION_ID_NAME_MAP.put((byte)26, "Stop");
        ACTION_ID_NAME_MAP.put((byte)30, "Return Chargo");
        ACTION_ID_NAME_MAP.put((byte)31, "Train");
        ACTION_ID_NAME_MAP.put((byte)32, "Cancel Train");
        ACTION_ID_NAME_MAP.put((byte)33, "Cloack");
        ACTION_ID_NAME_MAP.put((byte)34, "Decloack");
        ACTION_ID_NAME_MAP.put((byte)35, "Hatch");
        ACTION_ID_NAME_MAP.put((byte)37, "Unsiege");
        ACTION_ID_NAME_MAP.put((byte)38, "Siege");
        ACTION_ID_NAME_MAP.put((byte)39, "Build Interceptor/Scarab");
        ACTION_ID_NAME_MAP.put((byte)40, "Unload All");
        ACTION_ID_NAME_MAP.put((byte)41, "Unload");
        ACTION_ID_NAME_MAP.put((byte)42, "Merge Archon");
        ACTION_ID_NAME_MAP.put((byte)43, "Hold Position");
        ACTION_ID_NAME_MAP.put((byte)44, "Burrow");
        ACTION_ID_NAME_MAP.put((byte)45, "Unborrow");
        ACTION_ID_NAME_MAP.put((byte)46, "Cancel Nuke");
        ACTION_ID_NAME_MAP.put((byte)47, "Lift");
        ACTION_ID_NAME_MAP.put((byte)48, "Research");
        ACTION_ID_NAME_MAP.put((byte)49, "Cancel Research");
        ACTION_ID_NAME_MAP.put((byte)50, "Upgrade");
        ACTION_ID_NAME_MAP.put((byte)51, "!0x33");
        ACTION_ID_NAME_MAP.put((byte)53, "Morph");
        ACTION_ID_NAME_MAP.put((byte)54, "Stim");
        ACTION_ID_NAME_MAP.put((byte)87, "Leave Game");
        ACTION_ID_NAME_MAP.put((byte)88, "Minimap Ping");
        ACTION_ID_NAME_MAP.put((byte)90, "Merge Dark Archon");
        ACTION_ID_NAME_MAP.put((byte)92, "Game Chat");
        ACTION_ID_NAME_MAP.put((byte)-3, "Attack Move");
        ACTION_ID_NAME_MAP.put((byte)-4, "Gather");
        SUBACTION_ID_NAME_MAP = new HashMap<Byte, String>();
        SUBACTION_ID_NAME_MAP.put((byte)0, "Move");
        SUBACTION_ID_NAME_MAP.put((byte)6, "Move");
        SUBACTION_ID_NAME_MAP.put((byte)8, "Attack");
        SUBACTION_ID_NAME_MAP.put((byte)9, "Gather");
        SUBACTION_ID_NAME_MAP.put((byte)14, "Attack Move");
        SUBACTION_ID_NAME_MAP.put((byte)19, "Failed Casting");
        SUBACTION_ID_NAME_MAP.put((byte)27, "Infest CC");
        SUBACTION_ID_NAME_MAP.put((byte)34, "Repair");
        SUBACTION_ID_NAME_MAP.put((byte)39, "Clear Rally");
        SUBACTION_ID_NAME_MAP.put((byte)40, "Set Rally");
        SUBACTION_ID_NAME_MAP.put((byte)79, "Gather");
        SUBACTION_ID_NAME_MAP.put((byte)80, "Gather");
        SUBACTION_ID_NAME_MAP.put((byte)112, "Unload");
        SUBACTION_ID_NAME_MAP.put((byte)113, "Yamato");
        SUBACTION_ID_NAME_MAP.put((byte)115, "Lockdown");
        SUBACTION_ID_NAME_MAP.put((byte)119, "Dark Swarm");
        SUBACTION_ID_NAME_MAP.put((byte)120, "Parasite");
        SUBACTION_ID_NAME_MAP.put((byte)121, "Spawn Broodling");
        SUBACTION_ID_NAME_MAP.put((byte)122, "EMP");
        SUBACTION_ID_NAME_MAP.put((byte)126, "Launch Nuke");
        SUBACTION_ID_NAME_MAP.put((byte)-124, "Lay Mine");
        SUBACTION_ID_NAME_MAP.put((byte)-117, "Comsat Scan");
        SUBACTION_ID_NAME_MAP.put((byte)-115, "Defense Matrix");
        SUBACTION_ID_NAME_MAP.put((byte)-114, "Psionic Storm");
        SUBACTION_ID_NAME_MAP.put((byte)-113, "Recall");
        SUBACTION_ID_NAME_MAP.put((byte)-112, "Plague");
        SUBACTION_ID_NAME_MAP.put((byte)-111, "Consume");
        SUBACTION_ID_NAME_MAP.put((byte)-110, "Ensnare");
        SUBACTION_ID_NAME_MAP.put((byte)-109, "Statis");
        SUBACTION_ID_NAME_MAP.put((byte)-108, "Hallucination");
        SUBACTION_ID_NAME_MAP.put((byte)-104, "Patrol");
        SUBACTION_ID_NAME_MAP.put((byte)-79, "Heal");
        SUBACTION_ID_NAME_MAP.put((byte)-76, "Restore");
        SUBACTION_ID_NAME_MAP.put((byte)-75, "Distruption Web");
        SUBACTION_ID_NAME_MAP.put((byte)-74, "Mind Control");
        SUBACTION_ID_NAME_MAP.put((byte)-72, "Feedback");
        SUBACTION_ID_NAME_MAP.put((byte)-71, "Optic Flare");
        SUBACTION_ID_NAME_MAP.put((byte)-70, "Maelstorm");
        SUBACTION_ID_NAME_MAP.put((byte)-64, "Irradiate");
        RESEARCH_ID_NAME_MAP = new HashMap<Byte, String>();
        RESEARCH_ID_NAME_MAP.put((byte)0, "Stim Pack");
        RESEARCH_ID_NAME_MAP.put((byte)1, "Lockdown");
        RESEARCH_ID_NAME_MAP.put((byte)2, "EMP Shockwave");
        RESEARCH_ID_NAME_MAP.put((byte)3, "Spider Mines");
        RESEARCH_ID_NAME_MAP.put((byte)5, "Siege Tank");
        RESEARCH_ID_NAME_MAP.put((byte)7, "Irradiate");
        RESEARCH_ID_NAME_MAP.put((byte)8, "Yamato Gun");
        RESEARCH_ID_NAME_MAP.put((byte)9, "Cloacking Field (Wraith)");
        RESEARCH_ID_NAME_MAP.put((byte)10, "Personal Cloacking (Ghost)");
        RESEARCH_ID_NAME_MAP.put((byte)11, "Burrow");
        RESEARCH_ID_NAME_MAP.put((byte)13, "Spawn Broodling");
        RESEARCH_ID_NAME_MAP.put((byte)15, "Plague");
        RESEARCH_ID_NAME_MAP.put((byte)16, "Consume");
        RESEARCH_ID_NAME_MAP.put((byte)17, "Ensnare");
        RESEARCH_ID_NAME_MAP.put((byte)19, "Psionic Storm");
        RESEARCH_ID_NAME_MAP.put((byte)20, "Hallucination");
        RESEARCH_ID_NAME_MAP.put((byte)21, "Recall");
        RESEARCH_ID_NAME_MAP.put((byte)22, "Statis Field");
        RESEARCH_ID_NAME_MAP.put((byte)24, "Restoration");
        RESEARCH_ID_NAME_MAP.put((byte)25, "Distruption Web");
        RESEARCH_ID_NAME_MAP.put((byte)27, "Mind control");
        RESEARCH_ID_NAME_MAP.put((byte)30, "Optical Flare");
        RESEARCH_ID_NAME_MAP.put((byte)31, "Maelstorm");
        RESEARCH_ID_NAME_MAP.put((byte)32, "Lurker Aspect");
        UPGRADE_ID_NAME_MAP = new HashMap<Byte, String>();
        UPGRADE_ID_NAME_MAP.put((byte)0, "Terran Infantry Armor");
        UPGRADE_ID_NAME_MAP.put((byte)1, "Terran Vehicle Plating");
        UPGRADE_ID_NAME_MAP.put((byte)2, "Terran Ship Plating");
        UPGRADE_ID_NAME_MAP.put((byte)3, "Zerg Carapace");
        UPGRADE_ID_NAME_MAP.put((byte)4, "Zerg Flyer Carapace");
        UPGRADE_ID_NAME_MAP.put((byte)5, "Protoss Ground Armor");
        UPGRADE_ID_NAME_MAP.put((byte)6, "Protoss Air Armor");
        UPGRADE_ID_NAME_MAP.put((byte)7, "Terran Infantry Weapons");
        UPGRADE_ID_NAME_MAP.put((byte)8, "Terran Vehicle Weapons");
        UPGRADE_ID_NAME_MAP.put((byte)9, "Terran Ship Weapons");
        UPGRADE_ID_NAME_MAP.put((byte)10, "Zerg Melee Attacks");
        UPGRADE_ID_NAME_MAP.put((byte)11, "Zerg Missile Attacks");
        UPGRADE_ID_NAME_MAP.put((byte)12, "Zerg Flyer Attacks");
        UPGRADE_ID_NAME_MAP.put((byte)13, "Protoss Ground Weapons");
        UPGRADE_ID_NAME_MAP.put((byte)14, "Protoss Air Weapons");
        UPGRADE_ID_NAME_MAP.put((byte)15, "Protoss Plasma Shields");
        UPGRADE_ID_NAME_MAP.put((byte)16, "U-238 Shells (Marine Range)");
        UPGRADE_ID_NAME_MAP.put((byte)17, "Ion Thrusters (Vulture Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)19, "Titan Reactor (Science Vessel Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)20, "Ocular Implants (Ghost Sight)");
        UPGRADE_ID_NAME_MAP.put((byte)21, "Moebius Reactor (Ghost Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)22, "Apollo Reactor (Wraith Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)23, "Colossus Reactor (Battle Cruiser Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)24, "Ventral Sacs (Overlord Transport)");
        UPGRADE_ID_NAME_MAP.put((byte)25, "Antennae (Overlord Sight)");
        UPGRADE_ID_NAME_MAP.put((byte)26, "Pneumatized Carapace (Overlord Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)27, "Metabolic Boost (Zergling Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)28, "Adrenal Glands (Zergling Attack)");
        UPGRADE_ID_NAME_MAP.put((byte)29, "Muscular Augments (Hydralisk Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)30, "Grooved Spines (Hydralisk Range)");
        UPGRADE_ID_NAME_MAP.put((byte)31, "Gamete Meiosis (Queen Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)32, "Defiler Energy");
        UPGRADE_ID_NAME_MAP.put((byte)33, "Singularity Charge (Dragoon Range)");
        UPGRADE_ID_NAME_MAP.put((byte)34, "Leg Enhancement (Zealot Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)35, "Scarab Damage");
        UPGRADE_ID_NAME_MAP.put((byte)36, "Reaver Capacity");
        UPGRADE_ID_NAME_MAP.put((byte)37, "Gravitic Drive (Shuttle Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)38, "Sensor Array (Observer Sight)");
        UPGRADE_ID_NAME_MAP.put((byte)39, "Gravitic Booster (Observer Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)40, "Khaydarin Amulet (Templar Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)41, "Apial Sensors (Scout Sight)");
        UPGRADE_ID_NAME_MAP.put((byte)42, "Gravitic Thrusters (Scout Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)43, "Carrier Capacity");
        UPGRADE_ID_NAME_MAP.put((byte)44, "Khaydarin Core (Arbiter Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)47, "Argus Jewel (Corsair Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)49, "Argus Talisman (Dark Archon Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)51, "Caduceus Reactor (Medic Energy)");
        UPGRADE_ID_NAME_MAP.put((byte)52, "Chitinous Plating (Ultralisk Armor)");
        UPGRADE_ID_NAME_MAP.put((byte)53, "Anabolic Synthesis (Ultralisk Speed)");
        UPGRADE_ID_NAME_MAP.put((byte)54, "Charon Boosters (Goliath Range)");
        UNIT_IDS = new short[]{7, 41, 64};
        UNIT_ID_NAME_MAP = new HashMap<Short, String>();
        UNIT_ID_NAME_MAP.put((short)0, "Marine");
        UNIT_ID_NAME_MAP.put((short)1, "Ghost");
        UNIT_ID_NAME_MAP.put((short)2, "Vulture");
        UNIT_ID_NAME_MAP.put((short)3, "Goliath");
        UNIT_ID_NAME_MAP.put((short)5, "Siege Tank");
        UNIT_ID_NAME_MAP.put((short)7, "SCV");
        UNIT_ID_NAME_MAP.put((short)8, "Wraith");
        UNIT_ID_NAME_MAP.put((short)9, "Science Vessel");
        UNIT_ID_NAME_MAP.put((short)11, "Dropship");
        UNIT_ID_NAME_MAP.put((short)12, "Battlecruiser");
        UNIT_ID_NAME_MAP.put((short)14, "Nuke");
        UNIT_ID_NAME_MAP.put((short)32, "Firebat");
        UNIT_ID_NAME_MAP.put((short)34, "Medic");
        UNIT_ID_NAME_MAP.put((short)37, "Zergling");
        UNIT_ID_NAME_MAP.put((short)38, "Hydralisk");
        UNIT_ID_NAME_MAP.put((short)39, "Ultralisk");
        UNIT_ID_NAME_MAP.put((short)41, "Drone");
        UNIT_ID_NAME_MAP.put((short)42, "Overlord");
        UNIT_ID_NAME_MAP.put((short)43, "Mutalisk");
        UNIT_ID_NAME_MAP.put((short)44, "Guardian");
        UNIT_ID_NAME_MAP.put((short)45, "Queen");
        UNIT_ID_NAME_MAP.put((short)46, "Defiler");
        UNIT_ID_NAME_MAP.put((short)47, "Scourge");
        UNIT_ID_NAME_MAP.put((short)50, "Infested Terran");
        UNIT_ID_NAME_MAP.put((short)58, "Valkyrie");
        UNIT_ID_NAME_MAP.put((short)60, "Corsair");
        UNIT_ID_NAME_MAP.put((short)61, "Dark Templar");
        UNIT_ID_NAME_MAP.put((short)62, "Devourer");
        UNIT_ID_NAME_MAP.put((short)64, "Probe");
        UNIT_ID_NAME_MAP.put((short)65, "Zealot");
        UNIT_ID_NAME_MAP.put((short)66, "Dragoon");
        UNIT_ID_NAME_MAP.put((short)67, "High Templar");
        UNIT_ID_NAME_MAP.put((short)69, "Shuttle");
        UNIT_ID_NAME_MAP.put((short)70, "Scout");
        UNIT_ID_NAME_MAP.put((short)71, "Arbiter");
        UNIT_ID_NAME_MAP.put((short)72, "Carrier");
        UNIT_ID_NAME_MAP.put((short)83, "Reaver");
        UNIT_ID_NAME_MAP.put((short)84, "Observer");
        UNIT_ID_NAME_MAP.put((short)103, "Lurker");
        UNIT_ID_NAME_MAP.put((short)106, "Command Center");
        UNIT_ID_NAME_MAP.put((short)107, "ComSat");
        UNIT_ID_NAME_MAP.put((short)108, "Nuclear Silo");
        UNIT_ID_NAME_MAP.put((short)109, "Supply Depot");
        UNIT_ID_NAME_MAP.put((short)110, "Refinery");
        UNIT_ID_NAME_MAP.put((short)111, "Barracks");
        UNIT_ID_NAME_MAP.put((short)112, "Academy");
        UNIT_ID_NAME_MAP.put((short)113, "Factory");
        UNIT_ID_NAME_MAP.put((short)114, "Starport");
        UNIT_ID_NAME_MAP.put((short)115, "Control Tower");
        UNIT_ID_NAME_MAP.put((short)116, "Science Facility");
        UNIT_ID_NAME_MAP.put((short)117, "Covert Ops");
        UNIT_ID_NAME_MAP.put((short)118, "Physics Lab");
        UNIT_ID_NAME_MAP.put((short)120, "Machine Shop");
        UNIT_ID_NAME_MAP.put((short)122, "Engineering Bay");
        UNIT_ID_NAME_MAP.put((short)123, "Armory");
        UNIT_ID_NAME_MAP.put((short)124, "Missile Turret");
        UNIT_ID_NAME_MAP.put((short)125, "Bunker");
        UNIT_ID_NAME_MAP.put((short)130, "Infested CC");
        UNIT_ID_NAME_MAP.put((short)131, "Hatchery");
        UNIT_ID_NAME_MAP.put((short)132, "Lair");
        UNIT_ID_NAME_MAP.put((short)133, "Hive");
        UNIT_ID_NAME_MAP.put((short)134, "Nydus Canal");
        UNIT_ID_NAME_MAP.put((short)135, "Hydralisk Den");
        UNIT_ID_NAME_MAP.put((short)136, "Defiler Mound");
        UNIT_ID_NAME_MAP.put((short)137, "Greater Spire");
        UNIT_ID_NAME_MAP.put((short)138, "Queens Nest");
        UNIT_ID_NAME_MAP.put((short)139, "Evolution Chamber");
        UNIT_ID_NAME_MAP.put((short)140, "Ultralisk Cavern");
        UNIT_ID_NAME_MAP.put((short)141, "Spire");
        UNIT_ID_NAME_MAP.put((short)142, "Spawning Pool");
        UNIT_ID_NAME_MAP.put((short)143, "Creep Colony");
        UNIT_ID_NAME_MAP.put((short)144, "Spore Colony");
        UNIT_ID_NAME_MAP.put((short)146, "Sunken Colony");
        UNIT_ID_NAME_MAP.put((short)149, "Extractor");
        UNIT_ID_NAME_MAP.put((short)154, "Nexus");
        UNIT_ID_NAME_MAP.put((short)155, "Robotics Facility");
        UNIT_ID_NAME_MAP.put((short)156, "Pylon");
        UNIT_ID_NAME_MAP.put((short)157, "Assimilator");
        UNIT_ID_NAME_MAP.put((short)159, "Observatory");
        UNIT_ID_NAME_MAP.put((short)160, "Gateway");
        UNIT_ID_NAME_MAP.put((short)162, "Photon Cannon");
        UNIT_ID_NAME_MAP.put((short)163, "Citadel of Adun");
        UNIT_ID_NAME_MAP.put((short)164, "Cybernetics Core");
        UNIT_ID_NAME_MAP.put((short)165, "Templar Archives");
        UNIT_ID_NAME_MAP.put((short)166, "Forge");
        UNIT_ID_NAME_MAP.put((short)167, "Stargate");
        UNIT_ID_NAME_MAP.put((short)169, "Fleet Beacon");
        UNIT_ID_NAME_MAP.put((short)170, "Arbiter Tribunal");
        UNIT_ID_NAME_MAP.put((short)171, "Robotics Support Bay");
        UNIT_ID_NAME_MAP.put((short)172, "Shield Battery");
        UNIT_ID_NAME_MAP.put((short)192, "Larva");
        UNIT_ID_NAME_MAP.put((short)193, "Rine/Bat");
        UNIT_ID_NAME_MAP.put((short)194, "Dark Archon");
        UNIT_ID_NAME_MAP.put((short)195, "Archon");
        UNIT_ID_NAME_MAP.put((short)196, "Scarab");
        UNIT_ID_NAME_MAP.put((short)197, "Interceptor");
        UNIT_ID_NAME_MAP.put((short)198, "Interceptor/Scarab");
        BUILDING_ID_SIZE_MAP = new HashMap<Short, Size>();
        BUILDING_ID_SIZE_MAP.put((short)106, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)107, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)108, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)109, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)110, Size.SIZE4X2);
        BUILDING_ID_SIZE_MAP.put((short)111, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)112, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)113, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)114, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)115, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)116, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)117, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)118, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)120, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)122, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)123, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)124, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)125, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)130, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)131, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)132, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)133, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)134, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)135, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)136, Size.SIZE4X2);
        BUILDING_ID_SIZE_MAP.put((short)137, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)138, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)139, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)140, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)141, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)142, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)143, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)144, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)146, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)149, Size.SIZE4X2);
        BUILDING_ID_SIZE_MAP.put((short)154, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)155, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)156, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)157, Size.SIZE4X2);
        BUILDING_ID_SIZE_MAP.put((short)159, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)160, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)162, Size.SIZE2X2);
        BUILDING_ID_SIZE_MAP.put((short)163, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)164, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)165, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)166, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)167, Size.SIZE4X3);
        BUILDING_ID_SIZE_MAP.put((short)169, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)170, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)171, Size.SIZE3X2);
        BUILDING_ID_SIZE_MAP.put((short)172, Size.SIZE3X2);
        GAME_SPEED_MAP = new HashMap<Byte, String>();
        GAME_SPEED_MAP.put((byte)0, "Slowest");
        GAME_SPEED_MAP.put((byte)1, "Slower");
        GAME_SPEED_MAP.put((byte)2, "Slow");
        GAME_SPEED_MAP.put((byte)3, "Normal");
        GAME_SPEED_MAP.put((byte)4, "Fast");
        GAME_SPEED_MAP.put((byte)5, "Faster");
        GAME_SPEED_MAP.put((byte)6, "Fastest");
    }

    public Action(int iteration, String name, String parameters, String unitIds) {
        this.iteration = iteration;
        this.name = name;
        this.parameters = parameters;
        this.unitIds = unitIds;
        int actionNameIndex_ = -1;
        byte[] byArray = ACTION_IDS;
        int n = ACTION_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            int actionId = byArray[n2];
            if (name.equals(ACTION_ID_NAME_MAP.get((byte)actionId))) {
                actionNameIndex_ = actionId;
                break;
            }
            ++n2;
        }
        this.actionNameIndex = (byte)actionNameIndex_;
        this.subactionNameIndex = (byte)-1;
        int parameterBuildingNameIndex_ = -1;
        if (this.actionNameIndex == 9 || this.actionNameIndex == -2 || this.actionNameIndex == 31) {
            for (Map.Entry<Short, String> entry : UNIT_ID_NAME_MAP.entrySet()) {
                if (!parameters.startsWith(entry.getValue())) continue;
                parameterBuildingNameIndex_ = entry.getKey().shortValue();
                break;
            }
        }
        this.parameterBuildingNameIndex = (short)parameterBuildingNameIndex_;
        int parameterUnitNameIndex_ = -1;
        if (this.actionNameIndex == 9 && this.parameterBuildingNameIndex == -1) {
            short[] sArray = UNIT_IDS;
            int n3 = UNIT_IDS.length;
            int n4 = 0;
            while (n4 < n3) {
                int unitId = sArray[n4];
                if (parameters.equals(UNIT_ID_NAME_MAP.get((byte)unitId))) {
                    parameterUnitNameIndex_ = unitId;
                    break;
                }
                ++n4;
            }
        }
        this.parameterUnitNameIndex = (short)parameterUnitNameIndex_;
    }

    public Action(int iteration, String parameters, byte actionNameIndex) {
        this(iteration, parameters, actionNameIndex, -1, -1, -1);
    }

    public Action(int iteration, String parameters, byte actionNameIndex, short parameterUnitNameIndex, short parameterBuildingNameIndex) {
        this(iteration, parameters, actionNameIndex, -1, parameterUnitNameIndex, parameterBuildingNameIndex);
    }

    public Action(int iteration, String parameters, byte actionNameIndex, byte subactionNameIndex, short parameterUnitNameIndex, short parameterBuildingNameIndex) {
        this.iteration = iteration;
        this.name = null;
        this.parameters = parameters;
        this.unitIds = null;
        this.actionNameIndex = actionNameIndex;
        this.subactionNameIndex = subactionNameIndex;
        this.parameterUnitNameIndex = parameterUnitNameIndex;
        this.parameterBuildingNameIndex = parameterBuildingNameIndex;
    }

    public String toString() {
        return this.toString(null, false);
    }

    public String toString(String playerName, boolean timeInSeconds) {
        if (timeInSeconds && this.toStringValueSeconds == null || !timeInSeconds && this.toStringValue == null) {
            String actionName = null;
            if (this.subactionNameIndex != -1) {
                actionName = SUBACTION_ID_NAME_MAP.get(this.subactionNameIndex);
            }
            if (actionName == null && this.actionNameIndex != -1 && (actionName = ACTION_ID_NAME_MAP.get(this.actionNameIndex)) == null) {
                actionName = "0x" + Integer.toHexString(this.actionNameIndex & 0xFF);
            }
            if (actionName == null) {
                actionName = "<not parsed>";
            }
            StringBuilder actionStringBuilder = new StringBuilder();
            if (timeInSeconds) {
                ReplayHeader.formatFrames(this.iteration, actionStringBuilder, true);
            }
            Formatter actionStringFormatter = new Formatter(actionStringBuilder);
            if (playerName == null) {
                if (timeInSeconds) {
                    actionStringFormatter.format(" %-13s %s", actionName, this.parameters);
                } else {
                    actionStringFormatter.format("%6d %-13s %s", this.iteration, actionName, this.parameters);
                }
            } else if (timeInSeconds) {
                actionStringFormatter.format(" %-25s %-17s %s", playerName, actionName, this.parameters);
            } else {
                actionStringFormatter.format("%6d %-25s %-17s %s", this.iteration, playerName, actionName, this.parameters);
            }
            if (timeInSeconds) {
                this.toStringValueSeconds = actionStringBuilder.toString();
            } else {
                this.toStringValue = actionStringBuilder.toString();
            }
        }
        return timeInSeconds ? this.toStringValueSeconds : this.toStringValue;
    }

    @Override
    public int compareTo(Action anotherAction) {
        return this.iteration < anotherAction.iteration ? -1 : (this.iteration > anotherAction.iteration ? 1 : 0);
    }

    public static class Size {
        public final int width;
        public final int height;
        public static final Size SIZE4X3 = new Size(4, 3);
        public static final Size SIZE4X2 = new Size(4, 2);
        public static final Size SIZE3X2 = new Size(3, 2);
        public static final Size SIZE2X2 = new Size(2, 2);

        private Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

